/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.NotNull;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private UserJsonBean author;
    @JsonProperty
    private String body;
    @JsonProperty
    private UserJsonBean updateAuthor;
    @JsonProperty
    private String created;
    @JsonProperty
    private String updated;
    @JsonProperty
    private VisibilityJsonBean visibility;
    @JsonIgnore
    private boolean isVisibilitySet = false;
    @JsonIgnore
    private boolean isBodySet = false;
    public static final CommentJsonBean DOC_EXAMPLE = new CommentJsonBean();
    public static final CommentJsonBean DOC_UPDATE_EXAMPLE = new CommentJsonBean();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public void setAuthor(UserJsonBean author) {
        this.author = author;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
        this.isBodySet = true;
    }

    public UserJsonBean getUpdateAuthor() {
        return this.updateAuthor;
    }

    public void setUpdateAuthor(UserJsonBean updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public Date getCreated() {
        return Dates.fromTimeString(this.created);
    }

    public void setCreated(Date created) {
        this.created = Dates.asTimeString(created);
    }

    public Date getUpdated() {
        return Dates.fromTimeString(this.updated);
    }

    public void setUpdated(Date updated) {
        this.updated = Dates.asTimeString(updated);
    }

    @JsonIgnore
    public boolean isBodySet() {
        return this.isBodySet;
    }

    @JsonIgnore
    public boolean isVisibilitySet() {
        return this.isVisibilitySet;
    }

    @JsonProperty
    public VisibilityJsonBean getVisibility() {
        return this.visibility;
    }

    @JsonProperty
    public void setVisibility(VisibilityJsonBean visibility) {
        this.visibility = visibility;
        this.isVisibilitySet = true;
    }

    public static Collection<CommentJsonBean> shortBeans(Collection<Comment> comments, final JiraBaseUrls urls, final ProjectRoleManager projectRoleManager) {
        return Collections2.transform(comments, (Function)new Function<Comment, CommentJsonBean>(){

            public CommentJsonBean apply(Comment from) {
                return CommentJsonBean.shortBean(from, urls, projectRoleManager);
            }
        });
    }

    public static CommentJsonBean shortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager) {
        if (comment == null) {
            return null;
        }
        CommentJsonBean bean = new CommentJsonBean();
        CommentJsonBean.addNonRenderableStuff(bean, comment, urls, projectRoleManager);
        bean.body = comment.getBody();
        bean.setCreated(comment.getCreated());
        bean.setUpdated(comment.getUpdated());
        return bean;
    }

    public static Collection<CommentJsonBean> renderedShortBeans(Collection<Comment> comments, final JiraBaseUrls urls, final ProjectRoleManager projectRoleManager, final DateTimeFormatterFactory dateTimeFormatterFactory, final RendererManager rendererManager, final String rendererType, final IssueRenderContext renderContext) {
        return Lists.newArrayList((Iterable)Collections2.transform(comments, (Function)new Function<Comment, CommentJsonBean>(){

            public CommentJsonBean apply(Comment from) {
                return CommentJsonBean.renderedShortBean(from, urls, projectRoleManager, dateTimeFormatterFactory, rendererManager, rendererType, renderContext);
            }
        }));
    }

    public static CommentJsonBean renderedShortBean(Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, String rendererType, IssueRenderContext renderContext) {
        if (comment == null) {
            return null;
        }
        CommentJsonBean bean = new CommentJsonBean();
        CommentJsonBean.addNonRenderableStuff(bean, comment, urls, projectRoleManager);
        bean.body = StringUtils.isNotBlank((String)rendererType) ? rendererManager.getRenderedContent(rendererType, comment.getBody(), renderContext) : comment.getBody();
        bean.created = comment.getCreated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(comment.getCreated());
        bean.updated = comment.getUpdated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(comment.getUpdated());
        return bean;
    }

    private static void addNonRenderableStuff(CommentJsonBean bean, @NotNull Comment comment, JiraBaseUrls urls, ProjectRoleManager projectRoleManager) {
        bean.self = urls.restApi2BaseUrl() + "issue/" + comment.getIssue().getId() + "/comment/" + JiraUrlCodec.encode(comment.getId().toString());
        bean.id = comment.getId().toString();
        bean.author = UserJsonBean.shortBean(comment.getAuthorUser(), urls);
        bean.updateAuthor = UserJsonBean.shortBean(comment.getUpdateAuthorUser(), urls);
        bean.visibility = CommentJsonBean.getVisibilityBean(comment, projectRoleManager);
    }

    private static VisibilityJsonBean getVisibilityBean(Comment comment, ProjectRoleManager projectRoleManager) {
        VisibilityJsonBean visibilityBean = null;
        String groupLevel = comment.getGroupLevel();
        if (groupLevel != null) {
            visibilityBean = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, groupLevel);
        } else {
            Long roleId = comment.getRoleLevelId();
            if (roleId != null) {
                String roleName = projectRoleManager.getProjectRole(roleId).getName();
                visibilityBean = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, roleName);
            }
        }
        return visibilityBean;
    }

    static {
        DOC_EXAMPLE.setId("10000");
        DOC_EXAMPLE.setSelf("http://www.example.com/jira/rest/api/2.0/issue/10010/comment/10000");
        DOC_EXAMPLE.setAuthor(UserJsonBean.USER_SHORT_DOC_EXAMPLE);
        DOC_EXAMPLE.setUpdateAuthor(UserJsonBean.USER_SHORT_DOC_EXAMPLE);
        DOC_EXAMPLE.setBody("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.");
        DOC_EXAMPLE.setCreated(new Date());
        DOC_EXAMPLE.setUpdated(new Date());
        DOC_EXAMPLE.setVisibility(new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, "Administrators"));
        DOC_UPDATE_EXAMPLE.setBody("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.");
        DOC_UPDATE_EXAMPLE.setVisibility(new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, "Administrators"));
    }
}

