/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class WorkflowActionsBean {
    private static final Map<String, Long> screensForViews;
    private Map<String, String> availableViews;
    private FieldScreenManager fieldScreenManager;
    public static final long VIEW_COMMENTASSIGN_ID = 2L;
    public static final long VIEW_RESOLVE_ID = 3L;

    public Map<String, String> getAvailableViews() {
        if (this.availableViews == null) {
            this.availableViews = new LinkedHashMap<String, String>();
            this.availableViews.put("", "No view for transition");
            this.availableViews.put("commentassign", "Add comment and assign");
            this.availableViews.put("resolveissue", "Add comment, assign and set resolution");
        }
        return this.availableViews;
    }

    public String getSelectedView() {
        return "commentassign";
    }

    public FieldScreen getFieldScreenForView(ActionDescriptor actionDescriptor) {
        String view = actionDescriptor.getView();
        if (TextUtils.stringSet((String)view)) {
            Long fieldScreenId;
            if (screensForViews.containsKey(view)) {
                fieldScreenId = screensForViews.get(view);
            } else if (actionDescriptor.getMetaAttributes().containsKey("jira.fieldscreen.id")) {
                fieldScreenId = new Long((String)actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id"));
            } else {
                throw new IllegalArgumentException("Unknown workflow view '" + view + "', or cannot find attribute 'jira.fieldscreen.id' for workflow action '" + actionDescriptor.getId() + "'.");
            }
            FieldScreen fieldScreen = this.getFieldScreenManager().getFieldScreen(fieldScreenId);
            if (fieldScreen != null) {
                return fieldScreen;
            }
            throw new IllegalArgumentException("Cannot find Screen with id '" + fieldScreenId + "'.");
        }
        return null;
    }

    private FieldScreenManager getFieldScreenManager() {
        if (this.fieldScreenManager == null) {
            this.fieldScreenManager = ComponentAccessor.getFieldScreenManager();
        }
        return this.fieldScreenManager;
    }

    static {
        HashMap<String, Long> tmp = new HashMap<String, Long>();
        tmp.put("commentassign", 2L);
        tmp.put("resolveissue", 3L);
        screensForViews = Collections.unmodifiableMap(tmp);
    }
}

