/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.core.util.DateUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDurationUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@XmlRootElement(name="worklog")
public class WorklogJsonBean {
    @XmlElement
    private URI self;
    @XmlElement
    private UserJsonBean author;
    @XmlElement
    private UserJsonBean updateAuthor;
    @XmlElement
    private String comment;
    @XmlElement
    private String created;
    @XmlElement
    private String updated;
    @XmlElement
    private VisibilityJsonBean visibility;
    @JsonIgnore
    private boolean isVisibilitySet;
    @XmlElement
    private String started;
    @XmlElement
    private String timeSpent;
    @XmlElement
    private Long timeSpentSeconds;
    @XmlElement
    private String id;
    public static final WorklogJsonBean DOC_EXAMPLE;

    public static List<WorklogJsonBean> asBeans(List<Worklog> worklogs, final JiraBaseUrls uriInfo, final UserManager userManager, final TimeTrackingConfiguration timeTrackingConfiguration) {
        return Lists.newArrayList((Iterable)Iterables.transform(worklogs, (Function)new Function<Worklog, WorklogJsonBean>(){

            public WorklogJsonBean apply(@Nullable Worklog from) {
                return WorklogJsonBean.getWorklog(from, uriInfo, userManager, timeTrackingConfiguration);
            }
        }));
    }

    public static WorklogJsonBean getWorklog(Worklog log, JiraBaseUrls baseUrls, UserManager userManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        WorklogJsonBean bean = new WorklogJsonBean();
        WorklogJsonBean.addNonRenderableData(bean, log, baseUrls, userManager);
        bean.comment = log.getComment();
        bean.timeSpent = WorklogJsonBean.getTimeLoggedString(log.getTimeSpent(), timeTrackingConfiguration);
        bean.timeSpentSeconds = log.getTimeSpent();
        bean.created = Dates.asTimeString(log.getCreated());
        bean.updated = Dates.asTimeString(log.getUpdated());
        bean.started = Dates.asTimeString(log.getStartDate());
        return bean;
    }

    private static void addNonRenderableData(WorklogJsonBean bean, Worklog log, JiraBaseUrls baseUrls, UserManager userManager) {
        try {
            bean.self = new URI(baseUrls.restApi2BaseUrl() + "issue/" + log.getIssue().getId().toString() + "/worklog/" + log.getId().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to generate worklog self url", e);
        }
        bean.author = WorklogJsonBean.getUserBean(baseUrls, log.getAuthor(), userManager);
        bean.updateAuthor = WorklogJsonBean.getUserBean(baseUrls, log.getUpdateAuthor(), userManager);
        bean.id = Long.toString(log.getId());
        String groupLevel = log.getGroupLevel();
        ProjectRole roleLevel = log.getRoleLevel();
        if (groupLevel != null) {
            bean.visibility = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, groupLevel);
        } else if (roleLevel != null) {
            bean.visibility = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, roleLevel.getName());
        }
    }

    public static List<WorklogJsonBean> asRenderedBeans(List<Worklog> worklogs, final JiraBaseUrls uriInfo, final String rendererType, final IssueRenderContext renderContext) {
        return Lists.newArrayList((Iterable)Iterables.transform(worklogs, (Function)new Function<Worklog, WorklogJsonBean>(){

            public WorklogJsonBean apply(@Nullable Worklog from) {
                return WorklogJsonBean.getRenderedWorklog(from, uriInfo, rendererType, renderContext);
            }
        }));
    }

    public static WorklogJsonBean getRenderedWorklog(Worklog log, JiraBaseUrls baseUrls, String rendererType, IssueRenderContext renderContext) {
        WorklogJsonBean bean = new WorklogJsonBean();
        WorklogJsonBean.addNonRenderableData(bean, log, baseUrls, ComponentAccessor.getUserManager());
        if (StringUtils.isNotBlank((String)rendererType)) {
            RendererManager rendererManager = ComponentAccessor.getComponent(RendererManager.class);
            bean.comment = rendererManager.getRenderedContent(rendererType, log.getComment(), renderContext);
        } else {
            bean.comment = log.getComment();
        }
        JiraDurationUtils jiraDurationUtils = ComponentAccessor.getComponent(JiraDurationUtils.class);
        bean.timeSpent = jiraDurationUtils.getFormattedDuration(log.getTimeSpent(), ComponentAccessor.getJiraAuthenticationContext().getLocale());
        DateTimeFormatterFactory dateTimeFormatterFactory = ComponentAccessor.getComponent(DateTimeFormatterFactory.class);
        bean.created = log.getCreated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(log.getCreated());
        bean.updated = log.getUpdated() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(log.getUpdated());
        bean.started = log.getStartDate() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(log.getStartDate());
        return bean;
    }

    protected static UserJsonBean getUserBean(JiraBaseUrls uriInfo, String username, UserManager userManager) {
        User user = userManager.getUser(username);
        if (user != null) {
            return UserJsonBean.shortBean(user, uriInfo);
        }
        if (StringUtils.isNotBlank((String)username)) {
            UserJsonBean userJsonBean = new UserJsonBean();
            userJsonBean.setName(username);
            return userJsonBean;
        }
        return null;
    }

    private static String getTimeLoggedString(long timeSpent, TimeTrackingConfiguration timeTrackingConfiguration) {
        BigDecimal hoursPerDay = timeTrackingConfiguration.getHoursPerDay();
        BigDecimal daysPerWeek = timeTrackingConfiguration.getDaysPerWeek();
        BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
        long secondsPerDay = hoursPerDay.multiply(secondsPerHour).longValueExact();
        long secondsPerWeek = daysPerWeek.multiply(hoursPerDay).multiply(secondsPerHour).longValueExact();
        return DateUtils.getDurationStringSeconds((long)timeSpent, (long)secondsPerDay, (long)secondsPerWeek);
    }

    public UserJsonBean getAuthor() {
        return this.author;
    }

    public UserJsonBean getUpdateAuthor() {
        return this.updateAuthor;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreated() {
        return Dates.fromTimeString(this.created);
    }

    public Date getUpdated() {
        return Dates.fromTimeString(this.updated);
    }

    public Date getStarted() {
        return Dates.fromTimeString(this.started);
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public Long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }

    @JsonProperty
    public VisibilityJsonBean getVisibility() {
        return this.visibility;
    }

    @JsonProperty
    public void setVisibility(VisibilityJsonBean visibility) {
        this.isVisibilitySet = true;
        this.visibility = visibility;
    }

    @JsonIgnore
    public boolean isVisibilitySet() {
        return this.isVisibilitySet;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public URI getSelf() {
        return this.self;
    }

    static {
        try {
            DOC_EXAMPLE = new WorklogJsonBean();
            WorklogJsonBean.DOC_EXAMPLE.self = new URI("http://www.example.com/jira/rest/api/2.0/issue/10010/worklog/10000");
            WorklogJsonBean.DOC_EXAMPLE.author = UserJsonBean.USER_SHORT_DOC_EXAMPLE;
            WorklogJsonBean.DOC_EXAMPLE.updateAuthor = UserJsonBean.USER_SHORT_DOC_EXAMPLE;
            WorklogJsonBean.DOC_EXAMPLE.comment = "I did some work here.";
            WorklogJsonBean.DOC_EXAMPLE.visibility = new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, "jira-developers");
            WorklogJsonBean.DOC_EXAMPLE.started = Dates.asTimeString(new Date());
            WorklogJsonBean.DOC_EXAMPLE.timeSpent = "3h 20m";
            WorklogJsonBean.DOC_EXAMPLE.timeSpentSeconds = 12000L;
            WorklogJsonBean.DOC_EXAMPLE.id = "100028";
        }
        catch (URISyntaxException impossible) {
            throw new RuntimeException(impossible);
        }
    }
}

