/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.util.Set;

public interface MessageSet {
    public Set<String> getErrorMessages();

    public MessageLink getLinkForError(String var1);

    public Set<String> getErrorMessagesInEnglish();

    public Set<String> getWarningMessages();

    public MessageLink getLinkForWarning(String var1);

    public Set<String> getWarningMessagesInEnglish();

    public boolean hasAnyErrors();

    public boolean hasAnyWarnings();

    public boolean hasAnyMessages();

    public void addMessageSet(MessageSet var1);

    public void addErrorMessage(String var1);

    public void addErrorMessage(String var1, MessageLink var2);

    public void addErrorMessageInEnglish(String var1);

    public void addWarningMessage(String var1);

    public void addWarningMessage(String var1, MessageLink var2);

    public void addWarningMessageInEnglish(String var1);

    public static class MessageLink {
        private final String linkText;
        private final String linkUrl;
        private final boolean absolutePath;

        public MessageLink(String linkText, String linkUrl) {
            this.linkText = linkText;
            this.linkUrl = linkUrl;
            this.absolutePath = false;
        }

        public MessageLink(String linkText, String linkUrl, boolean absolutePath) {
            this.linkText = linkText;
            this.linkUrl = linkUrl;
            this.absolutePath = absolutePath;
        }

        public String getLinkText() {
            return this.linkText;
        }

        public String getLinkUrl() {
            return this.linkUrl;
        }

        public boolean isAbsolutePath() {
            return this.absolutePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageLink link = (MessageLink)o;
            if (this.absolutePath != link.absolutePath) {
                return false;
            }
            if (this.linkText != null ? !this.linkText.equals(link.linkText) : link.linkText != null) {
                return false;
            }
            return !(this.linkUrl != null ? !this.linkUrl.equals(link.linkUrl) : link.linkUrl != null);
        }

        public int hashCode() {
            int result = this.linkText != null ? this.linkText.hashCode() : 0;
            result = 31 * result + (this.linkUrl != null ? this.linkUrl.hashCode() : 0);
            result = 31 * result + (this.absolutePath ? 1 : 0);
            return result;
        }
    }
}

