/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.PercentageProgressCounter;
import com.atlassian.jira.util.dbc.Assertions;

class PercentageContext
implements Context {
    private final Sink sink;
    private final Progress progress;
    private final Context.Task task = new Context.Task(){

        @Override
        public void complete() {
            PercentageContext.this.progress.increment();
        }
    };

    public PercentageContext(int total, Sink sink) {
        Assertions.notNull("sink", sink);
        this.sink = sink;
        this.progress = new Progress(total);
    }

    @Override
    public Context.Task start(Object input) {
        return this.task;
    }

    @Override
    public void setName(String string) {
        this.sink.setName(string);
        this.progress.update();
    }

    private class Progress {
        private final PercentageProgressCounter counter;

        Progress(int total) {
            this.counter = new PercentageProgressCounter(total);
        }

        void increment() {
            if (this.counter.increment()) {
                this.update();
            }
        }

        void update() {
            PercentageContext.this.sink.updateProgress(this.counter.getPercentComplete());
        }
    }

    static interface Sink {
        public void setName(String var1);

        public void updateProgress(int var1);
    }
}

