/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.configurable.ObjectConfigurationFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.JiraService;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractService
implements JiraService {
    protected Logger log = Logger.getLogger((String)this.getClass().getName());
    protected String name;
    private PropertySet props;

    @Override
    public abstract void run();

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        this.props = props;
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public String getKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean hasProperty(String propertyKey) throws ObjectConfigurationException {
        return this.props.exists(propertyKey);
    }

    @Override
    public String getProperty(String propertyKey) throws ObjectConfigurationException {
        return this.props.getString(propertyKey);
    }

    @Override
    public String getTextProperty(String propertyKey) throws ObjectConfigurationException {
        return this.props.getText(propertyKey);
    }

    @Override
    public Long getLongProperty(String propertyKey) throws ObjectConfigurationException {
        String property = this.getProperty(propertyKey);
        try {
            return new Long(property);
        }
        catch (NumberFormatException e) {
            throw new ObjectConfigurationException("Could not get Long from " + property);
        }
    }

    @Override
    public String getDefaultProperty(String propertyKey) throws ObjectConfigurationException {
        return this.getObjectConfiguration().getFieldDefault(propertyKey);
    }

    @Override
    public PropertySet getProperties() throws ObjectConfigurationException {
        return this.props;
    }

    protected ObjectConfiguration getObjectConfiguration(String id, String xmlfile, Map<String, String[]> params) throws ObjectConfigurationException {
        ObjectConfigurationFactory objectConfigurationFactory = ComponentAccessor.getComponent(ObjectConfigurationFactory.class);
        if (!objectConfigurationFactory.hasObjectConfiguration(id)) {
            try {
                objectConfigurationFactory.loadObjectConfiguration(xmlfile, id, this.getClass().getClassLoader());
            }
            catch (ObjectConfigurationException ex) {
                throw new ObjectConfigurationException("Unable to load configuration for Service '" + this.getName() + "'. " + ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        return objectConfigurationFactory.getObjectConfiguration(id, params);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

