/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import java.util.Comparator;
import java.util.Locale;

public class UserStatisticsMapper
implements StatisticsMapper<User> {
    private final String clauseName;
    private final String indexedField;
    private final UserResolver userResolver;
    protected final JiraAuthenticationContext jiraAuthenticationContext;

    public UserStatisticsMapper(UserFieldSearchConstantsWithEmpty searchConstants, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this(searchConstants.getJqlClauseNames().getPrimaryName(), searchConstants.getEmptyIndexValue(), searchConstants.getIndexField(), userManager, jiraAuthenticationContext);
    }

    public UserStatisticsMapper(String clauseName, String emptyIndexValue, String indexedField, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.clauseName = Assertions.notBlank("clauseName", clauseName);
        this.indexedField = Assertions.notBlank("indexedField", indexedField);
        this.userResolver = new UserManagerResolver(userManager, emptyIndexValue);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public Comparator<User> getComparator() {
        return new UserResolvingComparator(this.userResolver, this.getLocale());
    }

    @Override
    public boolean isValidValue(User value) {
        return true;
    }

    @Override
    public User getValueFromLuceneField(String documentValue) {
        return (User)this.userResolver.apply(documentValue);
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    @Override
    public SearchRequest getSearchUrlSuffix(User value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery()).where().defaultAnd();
        if (value != null) {
            builder.addStringCondition(this.getClauseName(), value.getName());
        } else {
            builder.addEmptyCondition(this.getClauseName());
        }
        return new SearchRequest(builder.buildQuery());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public String getDocumentConstant() {
        return this.indexedField;
    }

    TerminalClause getUserClause(String name) {
        return new TerminalClauseImpl(this.clauseName, Operator.EQUALS, name);
    }

    TerminalClause getEmptyUserClause() {
        return new TerminalClauseImpl(this.clauseName, Operator.IS, EmptyOperand.EMPTY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserStatisticsMapper that = (UserStatisticsMapper)o;
        if (!this.clauseName.equals(that.clauseName)) {
            return false;
        }
        return this.indexedField.equals(that.indexedField);
    }

    @Override
    public int hashCode() {
        int result = this.clauseName.hashCode();
        result = 31 * result + this.indexedField.hashCode();
        return result;
    }

    static final class UserResolvingComparator
    implements Comparator<User> {
        private final UserBestNameComparator nameComparator;
        private final UserResolver resolver;

        public UserResolvingComparator(UserResolver resolver, Locale locale) {
            this.nameComparator = new UserBestNameComparator(locale);
            this.resolver = Assertions.notNull("userResolver", resolver);
        }

        @Override
        public int compare(User o1, User o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return this.nameComparator.compare((User)this.resolver.apply(o1.getName()), (User)this.resolver.apply(o2.getName()));
        }
    }

    static class UserManagerResolver
    implements UserResolver {
        private final UserManager userManager;
        private final String emptyIndexValue;

        public UserManagerResolver(UserManager userManager, String emptyIndexValue) {
            this.userManager = userManager;
            this.emptyIndexValue = emptyIndexValue;
        }

        public User apply(String documentValue) {
            if (this.emptyIndexValue != null && this.emptyIndexValue.equals(documentValue)) {
                return null;
            }
            if (documentValue == null) {
                return null;
            }
            return this.userManager.getUser(documentValue);
        }
    }

    static interface UserResolver
    extends Function<String, User> {
    }
}

