/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;

public abstract class AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private static final Logger log = Logger.getLogger(AbstractCustomFieldSearchInputTransformer.class);
    private final CustomField field;
    private final String urlParameterName;
    private final CustomFieldInputHelper customFieldInputHelper;

    public AbstractCustomFieldSearchInputTransformer(CustomField field, String urlParameterName, CustomFieldInputHelper customFieldInputHelper) {
        this.field = field;
        this.urlParameterName = urlParameterName;
        this.customFieldInputHelper = Assertions.notNull("customFieldInputHelper", customFieldInputHelper);
    }

    protected abstract Clause getClauseFromParams(User var1, CustomFieldParams var2);

    protected abstract CustomFieldParams getParamsFromSearchRequest(User var1, Query var2, SearchContext var3);

    @Override
    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        CustomFieldParams customFieldParams;
        if (fieldValuesHolder.containsKey(this.urlParameterName) && (customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.urlParameterName)) != null && !customFieldParams.isEmpty()) {
            return this.getClauseFromParams(searcher, customFieldParams);
        }
        return null;
    }

    @Override
    public void populateFromParams(User user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        this.getCustomField().populateFromParams(fieldValuesHolder, actionParams.getKeysAndValues());
    }

    @Override
    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        CustomFieldParams customFieldParams = this.getParamsFromSearchRequest(searcher, query, searchContext);
        if (customFieldParams != null && !customFieldParams.isEmpty()) {
            fieldValuesHolder.put(this.urlParameterName, customFieldParams);
        }
    }

    @Override
    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        if (fieldValuesHolder.containsKey(this.urlParameterName)) {
            CustomField customField = this.getCustomField();
            FieldConfig config = customField.getReleventConfig(searchContext);
            if (config != null) {
                CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get(this.urlParameterName);
                customField.getCustomFieldType().validateFromParams(customFieldParams, errors, config);
            } else {
                log.warn((Object)("Searcher " + this.urlParameterName + " (" + ClassUtils.getShortClassName(this.getClass()) + ") tried to search with context it does not exist for. The search context is " + searchContext));
            }
        }
    }

    protected String getClauseName(User searcher, ClauseNames clauseNames) {
        return this.customFieldInputHelper.getUniqueClauseName(searcher, clauseNames.getPrimaryName(), this.field.getName());
    }

    protected CustomField getCustomField() {
        return this.field;
    }
}

