/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.HashMap;
import java.util.Map;

public class ImportIdLinkCFType
extends NumberCFType
implements SortableCustomField<Double> {
    public static final String BUGZILLA_ID_TYPE = "importid";
    public static final String BUGZILLA_ID_SEARCHER = "exactnumber";
    public static final String BUGZILLA_ID_CF_NAME = "Bugzilla Id";
    private final ApplicationProperties applicationProperties;

    public ImportIdLinkCFType(CustomFieldValuePersister customFieldValuePersister, DoubleConverter doubleConverter, ApplicationProperties applicationProperties, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, doubleConverter, genericConfigManager);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, Double value) {
        if (value != null) {
            super.updateValue(customField, issue, value);
        }
    }

    @Override
    @NotNull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(super.getVelocityParameters(issue, field, fieldLayoutItem));
        String urlPrefix = this.applicationProperties.getDefaultBackedString("jira.importid.prefix");
        if (urlPrefix != null) {
            if (urlPrefix.equals("unconfigured")) {
                params.put("unconfigured", Boolean.TRUE);
            }
            params.put("urlPrefix", urlPrefix);
        }
        return params;
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    @Override
    public String getChangelogValue(CustomField field, Double value) {
        if (value != null) {
            return super.getChangelogValue(field, value);
        }
        return null;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitImportLink(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitImportLink(ImportIdLinkCFType var1);
    }
}

