/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypeImpl;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.option.CascadingOption;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CommentField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.types.Duration;
import com.atlassian.jira.util.collect.MapBuilder;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public final class JiraDataTypes {
    public static final JiraDataType ISSUE = new JiraDataTypeImpl(Issue.class);
    public static final JiraDataType PROJECT = new JiraDataTypeImpl(Project.class);
    public static final JiraDataType PROJECT_CATEGORY = new JiraDataTypeImpl(ProjectCategory.class);
    public static final JiraDataType VERSION = new JiraDataTypeImpl(Version.class);
    public static final JiraDataType COMPONENT = new JiraDataTypeImpl(ProjectComponent.class);
    public static final JiraDataType USER = new JiraDataTypeImpl(User.class);
    public static final JiraDataType GROUP = new JiraDataTypeImpl(Group.class);
    public static final JiraDataType PROJECT_ROLE = new JiraDataTypeImpl(ProjectRole.class);
    public static final JiraDataType PRIORITY = new JiraDataTypeImpl(Priority.class);
    public static final JiraDataType RESOLUTION = new JiraDataTypeImpl(Resolution.class);
    public static final JiraDataType ISSUE_TYPE = new JiraDataTypeImpl(IssueType.class);
    public static final JiraDataType STATUS = new JiraDataTypeImpl(Status.class);
    public static final JiraDataType CASCADING_OPTION = new JiraDataTypeImpl(CascadingOption.class);
    public static final JiraDataType OPTION = new JiraDataTypeImpl(Option.class);
    public static final JiraDataType SAVED_FILTER = new JiraDataTypeImpl(SearchRequest.class);
    public static final JiraDataType ISSUE_SECURITY_LEVEL = new JiraDataTypeImpl(IssueSecurityLevel.class);
    public static final JiraDataType LABEL = new JiraDataTypeImpl(Label.class);
    public static final JiraDataType DATE = new JiraDataTypeImpl(Date.class);
    public static final JiraDataType TEXT = new JiraDataTypeImpl(String.class);
    public static final JiraDataType NUMBER = new JiraDataTypeImpl(Number.class);
    public static final JiraDataType DURATION = new JiraDataTypeImpl(Duration.class);
    public static final JiraDataType URL = new JiraDataTypeImpl(URL.class);
    public static final JiraDataType ALL = new JiraDataTypeImpl(Object.class);

    public static String getType(Field field) {
        if (field instanceof CommentField) {
            return field.getClass().getCanonicalName();
        }
        JiraDataType dataType = JiraDataTypes.getFieldType(field.getId());
        if (dataType == null) {
            return field.getClass().getCanonicalName();
        }
        Collection<String> stringCollection = dataType.asStrings();
        if (stringCollection.size() == 1) {
            return stringCollection.iterator().next();
        }
        return stringCollection.toString();
    }

    public static String getType(String fieldId) {
        JiraDataType dataType = JiraDataTypes.getFieldType(fieldId);
        if (dataType == null) {
            return fieldId;
        }
        Collection<String> stringCollection = dataType.asStrings();
        if (stringCollection.size() == 1) {
            return stringCollection.iterator().next();
        }
        return stringCollection.toString();
    }

    public static JiraDataType getFieldType(String fieldId) {
        Map<String, JiraDataType> map = MapBuilder.newBuilder().add("project", PROJECT).add("versions", VERSION).add("assignee", USER).add("components", COMPONENT).add("comment", TEXT).add("description", TEXT).add("duedate", DATE).add("environment", TEXT).add("fixVersions", VERSION).add("issuekey", ISSUE).add("issuetype", ISSUE_TYPE).add("priority", PRIORITY).add("reporter", USER).add("security", ISSUE_SECURITY_LEVEL).add("summary", TEXT).add("created", DATE).add("updated", DATE).add("resolutiondate", DATE).add("status", STATUS).add("resolution", RESOLUTION).add("labels", LABEL).toFastMap();
        return map.get(fieldId);
    }
}

