/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.util.dbc.Assertions;

public class UserHistoryItem {
    public static final Type ISSUE = new Type("Issue");
    public static final Type PROJECT = new Type("Project");
    public static final Type JQL_QUERY = new Type("JQLQuery");
    public static final Type ADMIN_PAGE = new Type("AdminPage");
    public static final Type ASSIGNEE = new Type("Assignee");
    public static final Type DASHBOARD = new Type("Dashboard");
    public static final Type ISSUELINKTYPE = new Type("IssueLink");
    public static final Type RESOLUTION = new Type("Resolution");
    private final long lastViewed;
    private final Type type;
    private final String entityId;
    private final String data;

    public UserHistoryItem(Type type, String entityId, long lastViewed, String data) {
        Assertions.notNull("type", type);
        Assertions.notNull("entityId", entityId);
        Assertions.notNull("lastViewed", lastViewed);
        this.type = type;
        this.entityId = entityId;
        this.lastViewed = lastViewed;
        this.data = data;
    }

    public UserHistoryItem(Type type, String entityId, long lastViewed) {
        this(type, entityId, lastViewed, null);
    }

    public UserHistoryItem(Type type, String entityId) {
        this(type, entityId, System.currentTimeMillis());
    }

    public UserHistoryItem(Type type, String entityId, String data) {
        this(type, entityId, System.currentTimeMillis(), data);
    }

    public long getLastViewed() {
        return this.lastViewed;
    }

    public Type getType() {
        return this.type;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserHistoryItem that = (UserHistoryItem)o;
        if (!this.entityId.equals(that.entityId)) {
            return false;
        }
        if (this.lastViewed != that.lastViewed) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = Long.valueOf(this.lastViewed).hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.entityId.hashCode();
        return result;
    }

    public String toString() {
        return "UserHistoryItem{type=" + this.type + ", entityId='" + this.entityId + '\'' + ", lastViewed=" + this.lastViewed + '}';
    }

    public static class Type {
        private final String name;

        public Type(String name) {
            Assertions.notBlank("name", name);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Type other = (Type)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return this.name;
        }
    }
}

