/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.issue.search.searchers.util.RecursiveClauseVisitor;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class NamedTerminalClauseCollectingVisitor
extends RecursiveClauseVisitor
implements ClauseVisitor<Void> {
    private final Set<String> clauseNames;
    private final List<TerminalClause> namedClauses;

    public NamedTerminalClauseCollectingVisitor(String clauseName) {
        this(Collections.singleton(clauseName));
    }

    public NamedTerminalClauseCollectingVisitor(Collection<String> clauseNames) {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (clauseNames != null) {
            names.addAll(clauseNames);
        }
        this.clauseNames = Collections.unmodifiableSet(names);
        this.namedClauses = new ArrayList<TerminalClause>();
    }

    public List<TerminalClause> getNamedClauses() {
        return this.namedClauses;
    }

    public boolean containsNamedClause() {
        return !this.namedClauses.isEmpty();
    }

    @Override
    public Void visit(TerminalClause clause) {
        if (this.clauseNames.contains(clause.getName())) {
            this.namedClauses.add(clause);
        }
        return null;
    }
}

