/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LocalDateFactory {
    public static LocalDate from(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return LocalDateFactory.from(calendar);
    }

    public static LocalDate getLocalDate(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTime(date);
        return LocalDateFactory.from(calendar);
    }

    private static LocalDate from(Calendar calendar) {
        if (calendar.get(0) != 1) {
            throw new IllegalArgumentException("LocalDate only handles the Common Era - no BC dates are allowed.");
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return new LocalDate(year, month, day);
    }

    public static LocalDate fromIsoBasicFormat(String isoDate) {
        if (isoDate == null) {
            return null;
        }
        if (isoDate.length() != 8) {
            throw new IllegalArgumentException("Input must be in the format 'YYYYMMDD'.");
        }
        int year = Integer.parseInt(isoDate.substring(0, 4));
        int month = Integer.parseInt(isoDate.substring(4, 6));
        int day = Integer.parseInt(isoDate.substring(6, 8));
        return new LocalDate(year, month, day);
    }

    public static String toIsoBasic(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return LocalDateFactory.format4(localDate.getYear()) + LocalDateFactory.format2(localDate.getMonth()) + LocalDateFactory.format2(localDate.getDay());
    }

    private static String format4(int i) {
        if (i >= 0 && i < 10) {
            return "000" + i;
        }
        if (i >= 10 && i < 100) {
            return "00" + i;
        }
        if (i >= 100 && i < 1000) {
            return "0" + i;
        }
        if (i >= 1000 && i <= 9999) {
            return String.valueOf(i);
        }
        throw new IllegalArgumentException("Invalid value " + i + " must be between 0 and 9999");
    }

    private static String format2(int i) {
        if (i > 0 && i < 10) {
            return "0" + i;
        }
        if (i >= 10 && i < 100) {
            return String.valueOf(i);
        }
        throw new IllegalArgumentException("Invalid value " + i + " must be between 1 and 99");
    }
}

