/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.file;

import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.HandlerFactory;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractMessageHandlingService
extends AbstractService {
    private static final Logger log = Logger.getLogger(AbstractMessageHandlingService.class);
    public static final String KEY_HANDLER = "handler";
    public static final String KEY_HANDLER_PARAMS = "handler.params";
    protected volatile MessageHandler handler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        block7: {
            super.init(props);
            try {
                if (TextUtils.stringSet((String)this.getProperty(KEY_HANDLER))) {
                    MessageHandler messageHandler = HandlerFactory.getHandler(this.getProperty(KEY_HANDLER));
                    try {
                        if (this.hasProperty(KEY_HANDLER_PARAMS)) {
                            Map<String, String> handlerParams = ServiceUtils.getParameterMap(this.getProperty(KEY_HANDLER_PARAMS));
                            messageHandler.init(handlerParams);
                        }
                        break block7;
                    }
                    finally {
                        this.handler = messageHandler;
                    }
                }
                log.error((Object)("You must specify a valid handler class for the " + this.getClass().getName() + " Service."));
            }
            catch (Exception e) {
                log.error((Object)("Could not create handler (" + this.getProperty(KEY_HANDLER) + ") - " + e), (Throwable)e);
            }
        }
    }

    protected MessageHandler getHandler() {
        return this.handler;
    }
}

