/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json;

import java.util.Map;

public class JsonType {
    private final Type[] type;
    private Format format;
    private Map<String, JsonType> properties;
    private JsonType items;

    public JsonType(Type[] type, Map<String, JsonType> properties) {
        this.type = type;
        this.format = null;
        this.properties = properties;
        this.items = null;
    }

    public JsonType(Type[] type, Format format) {
        this.type = type;
        this.format = format;
        this.properties = null;
        this.items = null;
    }

    public JsonType(Type[] type, JsonType item) {
        this.type = type;
        this.format = null;
        this.properties = null;
        this.items = item;
    }

    public JsonType(Type[] type) {
        this.type = type;
        this.format = null;
        this.properties = null;
        this.items = null;
    }

    public JsonType(Type type, Map<String, JsonType> properties) {
        this.type = new Type[]{type};
        this.format = null;
        this.properties = properties;
        this.items = null;
    }

    public JsonType(Type type, Format format) {
        this.type = new Type[]{type};
        this.format = format;
        this.properties = null;
        this.items = null;
    }

    public JsonType(Type type, JsonType item) {
        this.type = new Type[]{type};
        this.format = null;
        this.properties = null;
        this.items = item;
    }

    public JsonType(Type type) {
        this.type = new Type[]{type};
        this.format = null;
        this.properties = null;
        this.items = null;
    }

    public Type[] getType() {
        return this.type;
    }

    public Format getFormat() {
        return this.format;
    }

    public Map<String, JsonType> getProperties() {
        return this.properties;
    }

    public JsonType getItems() {
        return this.items;
    }

    public static enum Format {
        DATE("date");

        private final String name;

        private Format(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        NULL("null"),
        OBJECT("object"),
        ARRAY("array"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

