/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.jira.issue.link.RemoteLink;

public class RemoteLinkBuilder {
    private Long id;
    private Long issueId;
    private String globalId;
    private String title;
    private String summary;
    private String url;
    private String iconUrl;
    private String iconTitle;
    private String relationship;
    private Boolean resolved;
    private String statusIconUrl;
    private String statusIconTitle;
    private String statusIconLink;
    private String applicationType;
    private String applicationName;

    public RemoteLinkBuilder() {
    }

    public RemoteLinkBuilder(RemoteLink remoteLink) {
        this.id(remoteLink.getId());
        this.issueId(remoteLink.getIssueId());
        this.globalId(remoteLink.getGlobalId());
        this.title(remoteLink.getTitle());
        this.summary(remoteLink.getSummary());
        this.url(remoteLink.getUrl());
        this.iconUrl(remoteLink.getIconUrl());
        this.iconTitle(remoteLink.getIconTitle());
        this.relationship(remoteLink.getRelationship());
        this.resolved(remoteLink.isResolved());
        this.statusIconUrl(remoteLink.getStatusIconUrl());
        this.statusIconTitle(remoteLink.getStatusIconTitle());
        this.statusIconLink(remoteLink.getStatusIconLink());
        this.applicationType(remoteLink.getApplicationType());
        this.applicationName(remoteLink.getApplicationName());
    }

    public RemoteLinkBuilder id(Long id) {
        this.id = id;
        return this;
    }

    public RemoteLinkBuilder issueId(Long issueId) {
        this.issueId = issueId;
        return this;
    }

    public RemoteLinkBuilder globalId(String globalId) {
        this.globalId = globalId;
        return this;
    }

    public RemoteLinkBuilder title(String title) {
        this.title = title;
        return this;
    }

    public RemoteLinkBuilder summary(String summary) {
        this.summary = summary;
        return this;
    }

    public RemoteLinkBuilder url(String url) {
        this.url = url;
        return this;
    }

    public RemoteLinkBuilder iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public RemoteLinkBuilder iconTitle(String iconTitle) {
        this.iconTitle = iconTitle;
        return this;
    }

    public RemoteLinkBuilder relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    public RemoteLinkBuilder resolved(Boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    public RemoteLinkBuilder statusIconUrl(String statusIconUrl) {
        this.statusIconUrl = statusIconUrl;
        return this;
    }

    public RemoteLinkBuilder statusIconTitle(String statusIconTitle) {
        this.statusIconTitle = statusIconTitle;
        return this;
    }

    public RemoteLinkBuilder statusIconLink(String statusIconLink) {
        this.statusIconLink = statusIconLink;
        return this;
    }

    public RemoteLinkBuilder applicationType(String applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public RemoteLinkBuilder applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public RemoteLink build() {
        return new RemoteLink(this.id, this.issueId, this.globalId, this.title, this.summary, this.url, this.iconUrl, this.iconTitle, this.relationship, this.resolved, this.statusIconUrl, this.statusIconTitle, this.statusIconLink, this.applicationType, this.applicationName);
    }
}

