/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.JiraActionSupport;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatUtils;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.hints.Hint;
import com.atlassian.jira.hints.HintManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.UriValidator;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.SafeRedirectChecker;
import com.atlassian.jira.web.util.AuthorizationSupport;
import com.atlassian.jira.web.util.CookieUtils;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;
import webwork.action.CoreActionContext;
import webwork.action.ServletActionContext;
import webwork.util.ValueStack;

@NotThreadSafe
public class JiraWebActionSupport
extends JiraActionSupport
implements ErrorCollection,
AuthorizationSupport {
    public static final String RETURN_URL_PARAMETER = "returnUrl";
    public static final String PERMISSION_VIOLATION_RESULT = "permissionviolation";
    public static final String ISSUE_NOT_FOUND_RESULT = "issuenotfound";
    private static final String X_ATLASSIAN_DIALOG_CONTROL = "X-Atlassian-Dialog-Control";
    private static final Pattern SELECTED_ISSUE_PATTERN = Pattern.compile("(&|&amp;)?selectedIssueId=[0-9]*");
    protected HttpServletRequest request = ServletActionContext.getRequest();
    private Map assignableUsers;
    private OutlookDate outlookDate;
    private String returnUrl;
    protected Collection savedFilters;
    private Project selectedProject;
    private boolean inline = false;
    private PermissionManager permissionManager;
    private AuthorizationSupport authorizationSupport;
    private GlobalPermissionManager globalPermissionManager;
    private ProjectManager projectManager;
    private VersionManager versionManager;
    private UserProjectHistoryManager userProjectHistoryManager;
    private HintManager hintManager;
    private FieldManager fieldManager;
    private SearchHandlerManager searchHandlerManager;
    private SearchSortUtil searchSortUtil;
    private JiraLicenseService jiraLicenseService;
    private PermissionSchemeManager permissionSchemeManager;
    private ApplicationProperties applicationProperties;
    private ConstantsManager constantsManager;
    private XsrfTokenGenerator xsrfTokenGenerator;
    private OutlookDateManager outlookDateManager;
    private UriValidator uriValidator;
    private PermissionContextFactory permissionContextFactory;
    private SafeRedirectChecker safeRedirectChecker;
    private Set<ErrorCollection.Reason> reasons = new HashSet<ErrorCollection.Reason>();
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter dmyDateFormatter;
    private JiraContactHelper jiraContactHelper;
    private UserManager userManager;

    @Override
    public User getLoggedInUser() {
        return ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
    }

    public String getXsrfToken() {
        return this.getXsrfTokenGenerator().generateToken(ActionContext.getRequest());
    }

    private XsrfTokenGenerator getXsrfTokenGenerator() {
        if (this.xsrfTokenGenerator == null) {
            this.xsrfTokenGenerator = this.getComponentInstanceOfType(XsrfTokenGenerator.class);
        }
        return this.xsrfTokenGenerator;
    }

    @Override
    public ApplicationProperties getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = this.getComponentInstanceOfType(ApplicationProperties.class);
        }
        return this.applicationProperties;
    }

    public UriValidator getUriValidator() {
        if (this.uriValidator == null) {
            this.uriValidator = this.getComponentInstanceOfType(UriValidator.class);
        }
        return this.uriValidator;
    }

    protected SafeRedirectChecker getRedirectChecker() {
        if (this.safeRedirectChecker == null) {
            this.safeRedirectChecker = this.getComponentInstanceOfType(SafeRedirectChecker.class);
        }
        return this.safeRedirectChecker;
    }

    protected GlobalPermissionManager getGlobalPermissionManager() {
        if (this.globalPermissionManager == null) {
            this.globalPermissionManager = this.getComponentInstanceOfType(GlobalPermissionManager.class);
        }
        return this.globalPermissionManager;
    }

    protected PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = this.getComponentInstanceOfType(PermissionManager.class);
        }
        return this.permissionManager;
    }

    protected UserProjectHistoryManager getUserProjectHistoryManager() {
        if (this.userProjectHistoryManager == null) {
            this.userProjectHistoryManager = this.getComponentInstanceOfType(UserProjectHistoryManager.class);
        }
        return this.userProjectHistoryManager;
    }

    public ConstantsManager getConstantsManager() {
        if (this.constantsManager == null) {
            this.constantsManager = this.getComponentInstanceOfType(ConstantsManager.class);
        }
        return this.constantsManager;
    }

    private PermissionContextFactory getPermissionContextFactory() {
        if (this.permissionContextFactory == null) {
            this.permissionContextFactory = this.getComponentInstanceOfType(PermissionContextFactory.class);
        }
        return this.permissionContextFactory;
    }

    private PermissionSchemeManager getPermissionSchemeManager() {
        if (this.permissionSchemeManager == null) {
            this.permissionSchemeManager = this.getComponentInstanceOfType(PermissionSchemeManager.class);
        }
        return this.permissionSchemeManager;
    }

    public ProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = this.getComponentInstanceOfType(ProjectManager.class);
        }
        return this.projectManager;
    }

    public VersionManager getVersionManager() {
        if (this.versionManager == null) {
            this.versionManager = this.getComponentInstanceOfType(VersionManager.class);
        }
        return this.versionManager;
    }

    private FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = this.getComponentInstanceOfType(FieldManager.class);
        }
        return this.fieldManager;
    }

    private SearchSortUtil getSearchSortUtil() {
        if (this.searchSortUtil == null) {
            this.searchSortUtil = this.getComponentInstanceOfType(SearchSortUtil.class);
        }
        return this.searchSortUtil;
    }

    private SearchHandlerManager getSearchHandlerManager() {
        if (this.searchHandlerManager == null) {
            this.searchHandlerManager = this.getComponentInstanceOfType(SearchHandlerManager.class);
        }
        return this.searchHandlerManager;
    }

    @Deprecated
    public OutlookDate getOutlookDate() {
        if (this.outlookDate == null) {
            this.outlookDate = this.getOutlookDateManager().getOutlookDate(this.getLocale());
        }
        return this.outlookDate;
    }

    private OutlookDateManager getOutlookDateManager() {
        if (this.outlookDateManager == null) {
            this.outlookDateManager = this.getComponentInstanceOfType(OutlookDateManager.class);
        }
        return this.outlookDateManager;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = this.getComponentInstanceOfType(DateTimeFormatterFactory.class).formatter().forLoggedInUser().withStyle(DateTimeStyle.RELATIVE);
        }
        return this.dateTimeFormatter;
    }

    public DateTimeFormatter getDmyDateFormatter() {
        if (this.dmyDateFormatter == null) {
            this.dmyDateFormatter = this.getComponentInstanceOfType(DateTimeFormatterFactory.class).formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE);
        }
        return this.dmyDateFormatter;
    }

    public JiraContactHelper getJiraContactHelper() {
        if (this.jiraContactHelper == null) {
            this.jiraContactHelper = this.getComponentInstanceOfType(JiraContactHelper.class);
        }
        return this.jiraContactHelper;
    }

    public UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = this.getComponentInstanceOfType(UserManager.class);
        }
        return this.userManager;
    }

    public String getAdministratorContactLink() {
        return this.getJiraContactHelper().getAdministratorContactLinkHtml(this.request.getContextPath(), this.getI18nHelper());
    }

    private JiraLicenseService getJiraLicenseService() {
        if (this.jiraLicenseService == null) {
            this.jiraLicenseService = this.getComponentInstanceOfType(JiraLicenseService.class);
        }
        return this.jiraLicenseService;
    }

    protected final HintManager getHintManager() {
        if (this.hintManager == null) {
            this.hintManager = this.getComponentInstanceOfType(HintManager.class);
        }
        return this.hintManager;
    }

    private AuthorizationSupport getAuthorizationSupport() {
        if (this.authorizationSupport == null) {
            this.authorizationSupport = this.getComponentInstanceOfType(AuthorizationSupport.class);
        }
        return this.authorizationSupport;
    }

    public String getRedirect(String defaultUrl) {
        String redirectUrl;
        if (StringUtils.isNotEmpty((String)this.getReturnUrl())) {
            redirectUrl = this.getReturnUrl();
            this.setReturnUrl(null);
        } else {
            this.setReturnUrl(null);
            redirectUrl = defaultUrl;
        }
        if (this.invalidInput()) {
            return "error";
        }
        if (ServletActionContext.getResponse() == null) {
            String message = "Called a web action as if it were non-web";
            this.log.warn((Object)"Called a web action as if it were non-web", (Throwable)new RuntimeException("Called a web action as if it were non-web"));
            return "success";
        }
        String redirect = StringUtils.isNotBlank((String)redirectUrl) && redirectUrl.charAt(0) == '/' && this.request != null ? this.insertContextPath(redirectUrl) : redirectUrl;
        return this.forceRedirect(redirect);
    }

    protected String forceRedirect(String redirect) {
        try {
            String returnUrl = this.getReturnUrl();
            if (StringUtils.isNotBlank((String)returnUrl)) {
                redirect = redirect.indexOf(63) == -1 ? redirect + "?" + "returnUrl=" + JiraUrlCodec.encode(returnUrl) : redirect + "&" + "returnUrl=" + JiraUrlCodec.encode(returnUrl);
            }
            if (ServletActionContext.getResponse() != null) {
                ServletActionContext.getResponse().sendRedirect(redirect);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("IOException trying to send redirect" + e), (Throwable)e);
        }
        return "none";
    }

    @Override
    public boolean isHasPermission(String permName) {
        return this.getAuthorizationSupport().isHasPermission(permName);
    }

    @Override
    public boolean isHasPermission(int permissionsId) {
        return this.getAuthorizationSupport().isHasPermission(permissionsId);
    }

    @Override
    public boolean isHasIssuePermission(String permName, GenericValue issue) {
        return this.getAuthorizationSupport().isHasIssuePermission(permName, issue);
    }

    @Override
    public boolean isHasIssuePermission(int permissionsId, GenericValue issue) {
        return this.getAuthorizationSupport().isHasIssuePermission(permissionsId, issue);
    }

    @Override
    public boolean isHasProjectPermission(String permName, GenericValue project) {
        return this.getAuthorizationSupport().isHasProjectPermission(permName, project);
    }

    @Override
    public boolean isHasProjectPermission(int permissionsId, GenericValue project) {
        return this.getAuthorizationSupport().isHasProjectPermission(permissionsId, project);
    }

    @Override
    @Deprecated
    public boolean isHasPermission(String permName, GenericValue entity) {
        return this.getAuthorizationSupport().isHasPermission(permName, entity);
    }

    public boolean isSystemAdministrator() {
        User currentUser = this.getLoggedInUser();
        return currentUser != null && this.getGlobalPermissionManager().hasPermission(44, currentUser);
    }

    public boolean isUserExists(String username) {
        return UserUtils.userExists(username);
    }

    public String getUserFullName(String username) {
        User user = this.getUserManager().getUser(username);
        if (username == null) {
            this.log.warn((Object)("Could not retrieve full name for user '" + username + "'! User does not exist!"));
            return username;
        }
        return user.getDisplayName();
    }

    @Override
    public void addErrorCollection(ErrorCollection errors) {
        this.addErrorMessages(errors.getErrorMessages());
        this.addErrors(errors.getErrors());
    }

    @Override
    public void addError(String field, String message, ErrorCollection.Reason reason) {
        this.addError(field, message);
        this.addReason(reason);
    }

    @Override
    public void addErrorMessage(String message, ErrorCollection.Reason reason) {
        this.addErrorMessage(message);
        this.addReason(reason);
    }

    @Override
    public void addReason(ErrorCollection.Reason reason) {
        this.reasons.add(reason);
    }

    @Override
    public void addReasons(Set<ErrorCollection.Reason> reasons) {
        this.reasons.addAll(reasons);
    }

    @Override
    public void setReasons(Set<ErrorCollection.Reason> reasons) {
        this.reasons = reasons;
    }

    @Override
    public Set<ErrorCollection.Reason> getReasons() {
        return this.reasons;
    }

    public Field getField(String id) {
        return this.getFieldManager().getField(id);
    }

    public List<String> getSearchSortDescriptions(SearchRequest searchRequest) {
        return this.getSearchSortUtil().getSearchSortDescriptions(searchRequest, this, this.getLoggedInUser());
    }

    public String getNameTranslation(GenericValue issueConstantGV) {
        if (issueConstantGV != null) {
            IssueConstant issueConstant = this.getConstantsManager().getIssueConstant(issueConstantGV);
            return issueConstant.getNameTranslation();
        }
        return null;
    }

    public String getDescTranslation(GenericValue issueConstantGV) {
        IssueConstant issueConstant = this.getConstantsManager().getIssueConstant(issueConstantGV);
        if (issueConstant == null) {
            throw new RuntimeException("No issue constant associated with " + issueConstantGV);
        }
        return issueConstant.getDescTranslation();
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getReturnUrlForCancelLink() {
        if (StringUtils.contains((String)this.returnUrl, (String)"selectedIssueId")) {
            return SELECTED_ISSUE_PATTERN.matcher(this.returnUrl).replaceFirst("");
        }
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        String safeReturnUrl = returnUrl != null ? this.getUriValidator().getSafeUri(JiraUrl.constructBaseUrl(this.request), returnUrl) : null;
        this.returnUrl = safeReturnUrl == null || this.getRedirectChecker().canRedirectTo(safeReturnUrl) ? safeReturnUrl : null;
    }

    @Override
    public Collection<String> getFlushedErrorMessages() {
        Collection errors = this.getErrorMessages();
        this.errorMessages = new ArrayList();
        return errors;
    }

    public String getLanguage() throws IOException {
        if (this.isEnglishCompatibleLocale()) {
            return "en";
        }
        return this.getLocale().getLanguage();
    }

    private boolean isEnglishCompatibleLocale() {
        return false;
    }

    public Project getSelectedProjectObject() {
        if (this.selectedProject == null) {
            this.selectedProject = this.getUserProjectHistoryManager().getCurrentProject(10, this.getLoggedInUser());
        }
        return this.selectedProject;
    }

    public GenericValue getSelectedProject() {
        Project project = this.getSelectedProjectObject();
        if (project != null) {
            return project.getGenericValue();
        }
        return null;
    }

    public void setSelectedProjectId(Long id) {
        Project project;
        this.selectedProject = null;
        if (id != null && (project = this.getProjectManager().getProjectObj(id)) != null) {
            this.getUserProjectHistoryManager().addProjectToHistory(this.getLoggedInUser(), project);
        }
    }

    public String getDateFormat() {
        return DateTimeFormatUtils.getDateFormat();
    }

    public String getDateTimeFormat() {
        return DateTimeFormatUtils.getDateTimeFormat();
    }

    public String getTimeFormat() {
        return DateTimeFormatUtils.getTimeFormat();
    }

    public String getWebworkStack(String selected) {
        ValueStack stack = CoreActionContext.getValueStack();
        Object selectedObj = stack.findValue(selected);
        StringBuffer buf = new StringBuffer();
        buf.append("<pre>");
        Iterator iter = stack.iterator();
        boolean highlighted = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            buf.append("<ul><li>");
            if (o == selectedObj) {
                highlighted = true;
                buf.append("<font color='red'>");
                buf.append(o);
                buf.append("</font>");
                continue;
            }
            buf.append(o);
        }
        buf.append("</pre>");
        if (!highlighted && selected != null) {
            buf.append("<font color='red'>");
            buf.append(selected);
            buf.append(" resolves to: ");
            buf.append(selectedObj);
            buf.append("</font>");
        }
        return buf.toString();
    }

    public String getWebworkStack() {
        return this.getWebworkStack(null);
    }

    public String getServerId() {
        return this.getJiraLicenseService().getServerId();
    }

    public JiraServiceContext getJiraServiceContext() {
        return new JiraServiceContextImpl(this.getLoggedInUser(), this);
    }

    public String htmlEncode(String encodeMe) {
        return TextUtils.htmlEncode((String)encodeMe);
    }

    public boolean isInlineDialogMode() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public String returnComplete() {
        return this.returnComplete(null);
    }

    public String returnComplete(String url) {
        if (this.isInlineDialogMode()) {
            return this.inlineDialogControl("DONE");
        }
        return this.returnWebResponse(url);
    }

    protected final String returnCompleteWithInlineRedirect(String url) {
        if (this.isInlineDialogMode()) {
            return this.inlineDialogControl("redirect:" + this.insertContextPath(url));
        }
        return this.returnWebResponse(url);
    }

    protected String insertContextPath(String url) {
        if (url.startsWith("/")) {
            String contextPath = this.request.getContextPath();
            url = contextPath == null ? url : contextPath + url;
        }
        return url;
    }

    private String returnWebResponse(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            if (url.equals("success") || url.equals("error") || url.equals("input") || url.equals("login") || url.equals("none")) {
                return url;
            }
            return this.getRedirect(url);
        }
        return "success";
    }

    private String inlineDialogControl(String headerValue) {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setStatus(200);
        response.setHeader(X_ATLASSIAN_DIALOG_CONTROL, headerValue);
        return "none";
    }

    protected final boolean hasErrorMessage(String errorMsg) {
        return this.getErrorMessages().contains(errorMsg);
    }

    protected final boolean hasErrorMessageByKey(String errorMsgKey) {
        return this.hasErrorMessage(this.getText(errorMsgKey));
    }

    protected final void addErrorMessageIfAbsent(String errorMsg) {
        if (!this.hasErrorMessage(errorMsg)) {
            this.addErrorMessage(errorMsg);
        }
    }

    protected final void addErrorMessageByKeyIfAbsent(String errorMsgKey) {
        this.addErrorMessageIfAbsent(this.getText(errorMsgKey));
    }

    public final Hint getHint(String context) {
        try {
            HintManager.Context realContext = HintManager.Context.valueOf(context.toUpperCase());
            return this.getHintManager().getHintForContext(this.getLoggedInUser(), new JiraHelper(ActionContext.getRequest()), realContext);
        }
        catch (IllegalArgumentException e) {
            this.log.warn((Object)("Illegal hint context '" + context + "' specified!"));
            return null;
        }
    }

    public final Hint getRandomHint() {
        return this.getHintManager().getRandomHint(this.getLoggedInUser(), new JiraHelper(ActionContext.getRequest()));
    }

    public String getConglomerateCookieValue(String cookieName, String key) {
        Map<String, String> map = CookieUtils.parseConglomerateCookie(cookieName, ActionContext.getRequest());
        String value = map.get(key);
        return value != null ? value : "";
    }

    public void setConglomerateCookieValue(String cookieName, String key, String value) {
        Map<String, String> map = CookieUtils.parseConglomerateCookie(cookieName, ActionContext.getRequest());
        if (StringUtils.isNotBlank((String)value)) {
            map.put(key, value);
        } else {
            map.remove(key);
        }
        Cookie cookie = CookieUtils.createConglomerateCookie(cookieName, map, ActionContext.getRequest());
        ActionContext.getResponse().addCookie(cookie);
    }
}

