/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.ErrorCollection;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractSingleFieldType
extends AbstractCustomFieldType {
    protected static final Logger log = Logger.getLogger(AbstractSingleFieldType.class);
    protected static final String FIELD_TYPE_STRING = "stringvalue";
    protected static final String FIELD_TYPE_TEXT = "textvalue";
    protected static final String FIELD_TYPE_DATE = "datevalue";
    protected static final String FIELD_TYPE_NUMBER = "numbervalue";
    protected final CustomFieldValuePersister customFieldValuePersister;
    protected final GenericConfigManager genericConfigManager;

    protected AbstractSingleFieldType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        this.customFieldValuePersister = customFieldValuePersister;
        this.genericConfigManager = genericConfigManager;
    }

    @Override
    public Object getValueFromIssue(CustomField field, Issue issue) {
        List values = this.customFieldValuePersister.getValues(field, issue.getId(), this.getDatabaseType());
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            log.error((Object)("More than one value stored for custom field id '" + field.getId() + "' for issue '" + issue.getKey() + "'.  Values " + values));
            return null;
        }
        Object databaseValue = values.get(0);
        if (databaseValue == null) {
            return null;
        }
        try {
            return this.getObjectFromDbValue(databaseValue);
        }
        catch (FieldValidationException e) {
            String message = "Issue " + issue.getKey() + " has an invalid value '" + databaseValue + "' stored in the field '" + field.getName() + "'.";
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            } else {
                log.warn((Object)(message + ' ' + e.getMessage()));
            }
            return null;
        }
    }

    public Set remove(CustomField field) {
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    @Override
    public void createValue(CustomField field, Issue issue, Object value) {
        this.customFieldValuePersister.createValues(field, issue.getId(), this.getDatabaseType(), EasyList.build((Object)this.getDbValueFromObject(value)));
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, Object value) {
        this.customFieldValuePersister.updateValues(customField, issue.getId(), this.getDatabaseType(), EasyList.build((Object)this.getDbValueFromObject(value)));
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Object value) {
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), this.getDbValueFromObject(value));
    }

    @Override
    public Object getDefaultValue(FieldConfig fieldConfig) {
        try {
            Object databaseValue = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
            if (databaseValue != null) {
                return this.getObjectFromDbValue(databaseValue);
            }
            return null;
        }
        catch (FieldValidationException e) {
            log.error((Object)"Incorrect formatted custom field stored as default", (Throwable)e);
            return null;
        }
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        try {
            this.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException e) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Override
    public Object getValueFromCustomFieldParams(CustomFieldParams relevantParams) throws FieldValidationException {
        if (relevantParams == null) {
            return null;
        }
        Collection normalParams = relevantParams.getValuesForKey(null);
        if (normalParams == null || normalParams.isEmpty()) {
            return null;
        }
        String singleParam = (String)normalParams.iterator().next();
        if (TextUtils.stringSet((String)singleParam)) {
            return this.getSingularObjectFromString(singleParam);
        }
        return null;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getFirstValueForNullKey();
    }

    @Override
    public String getChangelogValue(CustomField field, Object value) {
        if (value == null) {
            return "";
        }
        return this.getStringFromSingularObject(value);
    }

    protected abstract PersistenceFieldType getDatabaseType();

    protected abstract Object getDbValueFromObject(Object var1);

    protected abstract Object getObjectFromDbValue(Object var1) throws FieldValidationException;

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitSingleField(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitSingleField(AbstractSingleFieldType var1);
    }
}

