/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.service.util.handler.EntityCreationHandler;
import com.atlassian.jira.service.util.handler.MailHandlerExecutionMonitor;
import com.google.common.collect.Maps;
import java.util.Map;

public class DryRunEntityCreationHandler
implements EntityCreationHandler {
    private final Map<String, User> dummyUsersById = Maps.newHashMap();
    private final MailHandlerExecutionMonitor mailHandlerExecutionMonitor;

    public DryRunEntityCreationHandler(MailHandlerExecutionMonitor mailHandlerExecutionMonitor) {
        this.mailHandlerExecutionMonitor = mailHandlerExecutionMonitor;
    }

    @Override
    public User createUserWithNotification(String username, String password, String email, String fullname, int userEventType) throws PermissionException, CreateException {
        return this.createUserNoNotification(username, password, email, fullname);
    }

    @Override
    public User createUserNoNotification(String username, String password, String emailAddress, String displayName) throws PermissionException, CreateException {
        User user = this.dummyUsersById.get(username);
        if (user == null) {
            this.mailHandlerExecutionMonitor.addInfo("Creating user '" + username + "'");
            this.mailHandlerExecutionMonitor.elementCreated(MailHandlerExecutionMonitor.Element.USER);
            user = new ImmutableUser(-1L, username, displayName, emailAddress, true);
            this.dummyUsersById.put(username, user);
        }
        return user;
    }

    @Override
    public boolean isReal() {
        return false;
    }
}

