/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class Dates {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static String asTimeString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(TIME_FORMAT).format(date) : null;
    }

    public static String asTimeString(@Nullable Timestamp timestamp) {
        return timestamp != null ? Dates.asTimeString(new Date(timestamp.getTime())) : null;
    }

    public static Date fromTimeString(@Nullable String time) throws IllegalArgumentException {
        try {
            return time != null ? new SimpleDateFormat(TIME_FORMAT).parse(time) : null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing time: " + time, e);
        }
    }

    public static String asDateString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(DATE_FORMAT).format(date) : null;
    }

    public static String asDateString(@Nullable Timestamp timestamp) {
        return timestamp != null ? Dates.asDateString(new Date(timestamp.getTime())) : null;
    }

    public static Date fromDateString(@Nullable String date) throws IllegalArgumentException {
        try {
            return date != null ? new SimpleDateFormat(DATE_FORMAT).parse(date) : null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing date string: " + date, e);
        }
    }

    private Dates() {
    }

    public static class DateTimeAdapter
    extends XmlAdapter<String, Date> {
        public Date unmarshal(String s) throws Exception {
            return Dates.fromTimeString(s);
        }

        public String marshal(Date date) throws Exception {
            return Dates.asTimeString(date);
        }
    }

    public static class DateAdapter
    extends XmlAdapter<String, Date> {
        public Date unmarshal(String text) throws Exception {
            return Dates.fromDateString(text);
        }

        public String marshal(Date date) throws Exception {
            return Dates.asDateString(date);
        }
    }
}

