/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.configurable.ObjectConfigurable;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.util.handler.NaiveMailHandlerExecutionMonitor;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.sun.mail.pop3.POP3Message;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public abstract class MailFetcherService
extends AbstractMessageHandlingService
implements ObjectConfigurable {
    private static final Logger log = ComponentAccessor.getComponent(MailLoggingManager.class).getIncomingMailChildLogger("mailfetcherservice");
    private static final String OLD_MAIL_DISABLED_KEY = "atlassian.mail.popdisabled";
    private static final String MAIL_DISABLED_KEY = "atlassian.mail.fetchdisabled";
    public static final String KEY_PORT = "port";
    public static final String KEY_MAIL_SERVER = "popserver";
    public static final int MAX_READ_MESSAGES_DRY_RUN = 10;
    protected Long mailserverId = null;
    public static final String USE_SSL = "usessl";
    public static final String FORWARD_EMAIL = "forwardEmail";
    protected static final String DEFAULT_FOLDER = "INBOX";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private final ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
    private final String baseUrl = this.applicationProperties.getString("jira.baseurl");
    private static final String ERROR_TEMPLATE = "errorinhandler.vm";
    private ErrorCollection errors;
    private int port = -1;

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(KEY_MAIL_SERVER)) {
            try {
                this.mailserverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            }
            catch (Exception e) {
                log.error((Object)("Invalid mail server id: " + e), (Throwable)e);
            }
        }
        if (this.hasProperty(KEY_PORT)) {
            int parsedPort = PortUtil.parsePort(this.getProperty(KEY_PORT));
            if (parsedPort >= 0) {
                this.port = parsedPort;
            } else {
                this.port = -1;
                log.error((Object)("Invalid port number: " + this.getProperty(KEY_PORT) + " for mail service: " + this.getName() + ". Using the default port for this service type."));
            }
        }
    }

    protected void warn(String msg) {
        this.warn(msg, null);
    }

    protected void warn(String msg, @Nullable Throwable e) {
        this.errors.addErrorMessage(msg);
        log.warn((Object)this.addHandlerInfo(msg));
    }

    protected void error(String msg) {
        this.error(msg, null);
    }

    protected void error(String msg, @Nullable Throwable e) {
        this.errors.addErrorMessage(msg);
        log.error((Object)this.addHandlerInfo(msg), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Store store;
        Session session;
        this.errors = new SimpleErrorCollection();
        if (this.mailHandlerExecutionMonitor == null) {
            this.mailHandlerExecutionMonitor = new NaiveMailHandlerExecutionMonitor();
        }
        log.debug((Object)(this.getClass().getSimpleName() + " run() method has been called"));
        if (this.isMailDisabled()) {
            this.errors.addErrorMessage("Mail is disabled.");
            return;
        }
        MailServer mailserver = this.getMailServer();
        if (mailserver == null) {
            this.warn("no mail server returned from getMailServer(). Exiting run()");
            return;
        }
        log.debug((Object)("Using mail server [" + mailserver + "]"));
        String hostname = mailserver.getHostname();
        String username = mailserver.getUsername();
        String password = mailserver.getPassword();
        if (hostname == null || username == null || password == null) {
            this.warn("Cannot retrieve mail due to a missing parameter in Mail Server '" + mailserver.getName() + "': [host," + hostname + "],[username," + username + "],[password," + password + "]");
            return;
        }
        try {
            session = mailserver.getSession();
        }
        catch (Exception e) {
            this.error("Cannot create mail session: " + e.getMessage(), e);
            return;
        }
        String protocol = null;
        try {
            protocol = this.getProtocol(this.useSSL());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting store from the session using protocol [" + protocol + "]"));
            }
            store = session.getStore(protocol);
        }
        catch (NoSuchProviderException e) {
            this.error("Error getting provider for protocol " + protocol + ": " + (Object)((Object)e), e);
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connecting to mail store to host [" + hostname + "] and port [" + this.port + "]"));
            }
            store.connect(hostname, this.port, username, password);
            log.debug((Object)"Successfully connected to mail store");
        }
        catch (MessagingException e) {
            this.error("Error connecting to host '" + hostname + "' as user '" + username + "' via protocol '" + protocol + "': " + (Object)((Object)e), e);
            return;
        }
        Folder folder = null;
        try {
            String folderName = this.getFolderName();
            log.debug((Object)("Getting folder [" + folderName + "]"));
            folder = store.getFolder(folderName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got folder [" + folder + "], now opening it for read/write"));
            }
            folder.open(this.isDryRunMode() ? 1 : 2);
            Message[] messages = folder.getMessages();
            log.debug((Object)this.addHandlerInfo("Found " + messages.length + " message(s) in the " + protocol + " folder"));
            if (this.isDryRunMode()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Found ");
                sb.append(messages.length);
                sb.append(" message(s) in the ");
                sb.append(protocol);
                sb.append(" folder.");
                if (messages.length > 10) {
                    sb.append(" Only first 10 messages will be processed in test mode");
                }
                this.mailHandlerExecutionMonitor.addInfo(sb.toString());
            }
            this.mailHandlerExecutionMonitor.setNumMessages(messages.length);
            int messagesLength = messages.length;
            for (int i = 0; i < messagesLength; ++i) {
                Message message = messages[i];
                if (this.isDryRunMode() && i >= 10) {
                    log.debug((Object)"In dry-run mode only first 10 messages are processed. Skipping the rest");
                    break;
                }
                log.debug((Object)"Processing message");
                this.getHandler().setMailHandlerExecutionMonitor(this.mailHandlerExecutionMonitor);
                boolean deleteThisMessage = false;
                String msgId = null;
                try {
                    String string = msgId = message.getHeader("Message-ID") != null ? message.getHeader("Message-ID")[0] : "null";
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("Message Subject: " + message.getSubject()));
                            log.debug((Object)("Message-ID: " + msgId));
                        }
                        catch (MessagingException e) {
                            this.warn("Messaging exception thrown on getting message subject. Message may have corrupt headers.", e);
                        }
                    }
                    log.debug((Object)"Calling hadleMessage");
                    deleteThisMessage = this.getHandler().handleMessage(message);
                    if (!this.mailHandlerExecutionMonitor.hasErrors() || this.forwardEmailParam() == null || deleteThisMessage) continue;
                    log.debug((Object)("Forwarding Message: " + msgId));
                    deleteThisMessage = this.forwardEmail(message);
                    continue;
                }
                catch (Exception e) {
                    this.error("Exception: " + e.getLocalizedMessage(), e);
                    continue;
                }
                finally {
                    if (message != null) {
                        if (message instanceof POP3Message) {
                            ((POP3Message)message).invalidate(true);
                        }
                        if (deleteThisMessage) {
                            if (!this.isDryRunMode()) {
                                log.debug((Object)("Deleting Message: " + msgId));
                                message.setFlag(Flags.Flag.DELETED, true);
                            } else {
                                this.mailHandlerExecutionMonitor.addInfo("Deleting Message '" + message.getSubject() + "'");
                                log.debug((Object)("Deleting Message: " + msgId + " (skipped due to dry-run mode)"));
                            }
                        }
                    }
                }
            }
        }
        catch (MessagingException e) {
            this.error("Messaging Exception in service '" + this.getClass().getName() + "' when getting mail: " + e.getMessage(), e);
        }
        finally {
            try {
                if (folder != null) {
                    log.debug((Object)"Closing folder");
                    folder.close(true);
                }
                log.debug((Object)"Closing store");
                store.close();
            }
            catch (Exception e) {
                log.debug((Object)this.addHandlerInfo("Error whilst closing folder and store: " + e.getMessage()));
            }
        }
    }

    MailServer getMailServer() {
        MailServer mailserver = null;
        if (this.mailserverId != null) {
            try {
                mailserver = MailFactory.getServerManager().getMailServer(new Long(this.getProperty(KEY_MAIL_SERVER)));
            }
            catch (Exception e) {
                this.error("Could not retrieve mail server: " + e, e);
            }
        } else {
            this.error(this.getClass().getName() + " cannot run without a configured Mail Server");
        }
        return mailserver;
    }

    boolean isMailDisabled() {
        if (Boolean.getBoolean(OLD_MAIL_DISABLED_KEY)) {
            log.info((Object)"Service disabled by 'atlassian.mail.popdisabled' property.");
            return true;
        }
        if (Boolean.getBoolean(MAIL_DISABLED_KEY)) {
            log.info((Object)"Service disabled by 'atlassian.mail.fetchdisabled' property.");
            return true;
        }
        return false;
    }

    protected abstract String getProtocol(boolean var1);

    protected abstract String getFolderName();

    private boolean useSSL() {
        try {
            return "true".equals(this.getProperty(USE_SSL));
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving SSL flag."), (Throwable)((Object)e));
        }
    }

    private String forwardEmailParam() {
        try {
            return this.getProperty(FORWARD_EMAIL);
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving Forward Email flag."), (Throwable)((Object)e));
        }
    }

    private com.atlassian.jira.mail.Email createErrorForwardEmail(Message message) throws VelocityException, MessagingException {
        com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(this.forwardEmailParam());
        String error = this.mailHandlerExecutionMonitor.getErrorsAsString();
        String exceptionString = this.mailHandlerExecutionMonitor.getExceptionsAsString();
        email.setSubject(MailFetcherService.getI18nHelper().getText("template.errorinhandler.subject", message.getSubject()));
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.putAll(this.getVelocityParams(error));
        String body = ComponentAccessor.getVelocityManager().getEncodedBody(EMAIL_TEMPLATES, "text/errorinhandler.vm", this.baseUrl, this.applicationProperties.getString("webwork.i18n.encoding"), contextParams);
        email.setBody(body);
        MimeMultipart mp = new MimeMultipart();
        if (exceptionString != null) {
            MimeBodyPart exception = new MimeBodyPart();
            exception.setContent((Object)exceptionString, "text/plain");
            exception.setFileName("ErrorStackTrace.txt");
            mp.addBodyPart((BodyPart)exception);
        }
        MimeBodyPart messageAttachment = new MimeBodyPart();
        messageAttachment.setContent((Object)message, "message/rfc822");
        String subject = message.getSubject();
        if (StringUtils.isBlank((String)subject)) {
            subject = "NoSubject";
        }
        messageAttachment.setFileName(subject + ".eml");
        mp.addBodyPart((BodyPart)messageAttachment);
        email.setMultipart((Multipart)mp);
        return email;
    }

    private boolean forwardEmail(Message message) throws MailException {
        if (TextUtils.verifyEmail((String)this.forwardEmailParam())) {
            try {
                com.atlassian.jira.mail.Email email = this.createErrorForwardEmail(message);
                this.sendMail(email);
                return true;
            }
            catch (VelocityException e) {
                this.error("Could not create email template for.", e);
            }
            catch (MessagingException e) {
                this.error("Could not retrieve information from message.", e);
            }
        } else {
            this.warn("Forward Email is invalid.");
        }
        return false;
    }

    private void sendMail(com.atlassian.jira.mail.Email email) throws MailException {
        SMTPMailServer mailserver = MailFactory.getServerManager().getDefaultSMTPMailServer();
        if (mailserver == null) {
            this.warn("You do not currently have a smtp mail server set up yet.");
        } else if (MailFactory.isSendingDisabled()) {
            this.warn("Sending mail is currently disabled in Jira.");
        } else {
            email.setFrom(mailserver.getDefaultFrom());
            if (!this.isDryRunMode()) {
                log.debug((Object)("Sending mail to [" + email.getTo() + "]"));
                mailserver.send((Email)email);
            } else {
                this.mailHandlerExecutionMonitor.addInfo("Sending mail to '" + email.getTo() + "'");
                log.debug((Object)("Sending mail to [" + email.getTo() + "] skipped due to dry-run mode"));
            }
        }
    }

    private Map<String, Object> getVelocityParams(String error) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String handlerName = this.getHandler().getClass().toString();
        try {
            params.put("i18n", MailFetcherService.getI18nHelper());
            params.put("handlerName", handlerName);
            Long serverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            params.put("serverName", MailFactory.getServerManager().getMailServer(serverId).getName());
            params.put("error", error);
            params.put("baseurl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
        }
        catch (ObjectConfigurationException e) {
            this.error("Could not retrieve mail server", (Throwable)((Object)e));
        }
        catch (MailException e) {
            this.error("Could not retrieve mail server", e);
        }
        return params;
    }

    private String addHandlerInfo(String msg) {
        return this.getName() + "[" + this.mailserverId + "]: " + msg;
    }

    private static I18nHelper getI18nHelper() {
        return ComponentAccessor.getI18nHelperFactory().getInstance((User)null);
    }

    @Nullable
    public ErrorCollection getErrors() {
        return this.errors;
    }
}

