/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.util.HitCollectorUtil;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public abstract class AbstractOneDimensionalHitCollector
extends Collector {
    private final String fieldId;
    private Collection<String>[] docToTerms;
    private Collection<String>[] projectDocToTerms;
    private Collection<String>[] issueTypeDocToTerms;
    private final FieldVisibilityManager fieldVisibilityManager;
    private long irrelevantCount = 0L;
    private long hitCount = 0L;
    private int docBase = 0;

    public AbstractOneDimensionalHitCollector(final String fieldId, final IndexReader indexReader, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.fieldId = new HitCollectorUtil().getFieldId(fieldId);
        this.docToTerms = readerCache.get(indexReader, fieldId, new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, fieldId);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
        this.projectDocToTerms = readerCache.get(indexReader, SystemSearchConstants.forProject().getIndexField(), new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, SystemSearchConstants.forProject().getIndexField());
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
        this.issueTypeDocToTerms = readerCache.get(indexReader, SystemSearchConstants.forIssueType().getIndexField(), new Supplier<Collection<String>[]>(){

            @Override
            public Collection<String>[] get() {
                try {
                    return JiraLuceneFieldFinder.getInstance().getMatches(indexReader, SystemSearchConstants.forIssueType().getIndexField());
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        });
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int i) {
        ++this.hitCount;
        Collection<String> terms = this.docToTerms[this.docBase + i];
        if (terms == null) {
            String issueTypeId;
            Long projectId = new Long(this.projectDocToTerms[i].iterator().next());
            if (this.fieldVisibilityManager.isFieldHidden(projectId, this.fieldId, issueTypeId = this.issueTypeDocToTerms[i].iterator().next())) {
                ++this.irrelevantCount;
                this.collectIrrelevant(i);
            } else {
                this.collectWithTerms(this.docBase + i, terms);
            }
        } else {
            this.collectWithTerms(this.docBase + i, terms);
        }
    }

    public long getIrrelevantCount() {
        return this.irrelevantCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    protected abstract void collectIrrelevant(int var1);

    protected abstract void collectWithTerms(int var1, Collection<String> var2);
}

