/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

public class MappedSortComparator
extends FieldComparatorSource {
    private final LuceneFieldSorter sorter;

    public MappedSortComparator(LuceneFieldSorter sorter) {
        this.sorter = sorter;
    }

    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        return new InternalFieldComparator(numHits, fieldname, this.sorter);
    }

    Object[] getLuceneValues(String field, IndexReader reader) throws IOException {
        return JiraLuceneFieldFinder.getInstance().getCustom(reader, field, this);
    }

    public Object getComparable(String termtext) {
        return this.sorter.getValueFromLuceneField(termtext);
    }

    public Comparator getComparator() {
        return this.sorter.getComparator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MappedSortComparator that = (MappedSortComparator)((Object)o);
        return this.sorter == null ? that.sorter == null : ((Object)this.sorter).equals(that.sorter);
    }

    public int hashCode() {
        return this.sorter != null ? ((Object)this.sorter).hashCode() : 0;
    }

    public final class InternalFieldComparator
    extends FieldComparator {
        private final Object[] values;
        private Object[] currentDocumentValues;
        private final String field;
        private LuceneFieldSorter sorter;
        private Object bottom;

        InternalFieldComparator(int numHits, String field, LuceneFieldSorter sorter) {
            this.values = new Object[numHits];
            this.field = field;
            this.sorter = sorter;
        }

        public int compare(int slot1, int slot2) {
            Object v1 = this.values[slot1];
            Object v2 = this.values[slot2];
            if (v1 == null) {
                if (v2 == null) {
                    return 0;
                }
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return this.sorter.getComparator().compare(v1, v2);
        }

        public int compareBottom(int doc) {
            Object v2 = this.currentDocumentValues[doc];
            if (this.bottom == null) {
                if (v2 == null) {
                    return 0;
                }
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return this.sorter.getComparator().compare(this.bottom, v2);
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.currentDocumentValues[doc];
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentDocumentValues = MappedSortComparator.this.getLuceneValues(this.field, reader);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Comparable<?> value(int slot) {
            return null;
        }
    }
}

