/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonProperty;

public class VersionJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String name;
    @JsonProperty
    private Boolean archived;
    @JsonProperty
    private Boolean released;
    @JsonProperty
    @XmlJavaTypeAdapter(value=Dates.DateAdapter.class)
    private Date releaseDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public Boolean isReleased() {
        return this.released;
    }

    public Boolean isArchived() {
        return this.archived;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public void setId(Long id) {
        this.id = id == null ? null : id.toString();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public void setReleased(Boolean released) {
        this.released = released;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public static Collection<VersionJsonBean> shortBeans(Collection<Version> versions, final JiraBaseUrls urls) {
        return Lists.newArrayList((Iterable)Collections2.transform(versions, (Function)new Function<Version, VersionJsonBean>(){

            public VersionJsonBean apply(Version from) {
                return VersionJsonBean.shortBean(from, urls);
            }
        }));
    }

    public static VersionJsonBean shortBean(Version version, JiraBaseUrls urls) {
        if (version == null) {
            return null;
        }
        VersionJsonBean bean = new VersionJsonBean();
        bean.self = urls.restApi2BaseUrl() + "version/" + JiraUrlCodec.encode(version.getId().toString());
        bean.id = version.getId().toString();
        bean.description = version.getDescription();
        bean.name = version.getName();
        bean.released = version.isReleased();
        bean.releaseDate = version.getReleaseDate();
        bean.archived = version.isArchived();
        return bean;
    }
}

