/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatusJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String statusColor;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;
    @JsonProperty
    private String id;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static StatusJsonBean shortBean(Status status, JiraBaseUrls urls) {
        if (status == null) {
            return null;
        }
        StatusJsonBean bean = new StatusJsonBean();
        bean.self = urls.restApi2BaseUrl() + "status/" + JiraUrlCodec.encode(status.getId());
        bean.name = status.getNameTranslation();
        bean.id = status.getId();
        bean.iconUrl = urls.baseUrl() + status.getIconUrl();
        return bean;
    }

    public static StatusJsonBean fullBean(Status status, JiraBaseUrls urls) {
        if (status == null) {
            return null;
        }
        StatusJsonBean bean = StatusJsonBean.shortBean(status, urls);
        bean.description = status.getDescTranslation();
        return bean;
    }

    public static Collection<StatusJsonBean> shortBeans(Collection<Status> allowedValues, final JiraBaseUrls baseUrls) {
        return Lists.newArrayList((Iterable)Collections2.transform(allowedValues, (Function)new Function<Status, StatusJsonBean>(){

            public StatusJsonBean apply(Status from) {
                return StatusJsonBean.shortBean(from, baseUrls);
            }
        }));
    }

    public static StatusJsonBean fullBean(String id, String name, String self, String iconUrl, String description) {
        StatusJsonBean bean = new StatusJsonBean();
        bean.self = self;
        bean.name = name;
        bean.id = id;
        bean.iconUrl = iconUrl;
        bean.description = description;
        return bean;
    }
}

