/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.LinkedIssueTypeBean;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class IssueLinkBeanBuilder {
    private final ApplicationProperties applicationProperties;
    private final IssueLinkManager issueLinkManager;
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final Issue issue;

    public IssueLinkBeanBuilder(ApplicationProperties applicationProperties, IssueLinkManager issueLinkManager, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, Issue issue) {
        this.applicationProperties = applicationProperties;
        this.issueLinkManager = issueLinkManager;
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issue = issue;
    }

    public List<IssueLinkBean> buildIssueLinks() {
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return null;
        }
        ArrayList linkBeans = Lists.newArrayList();
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(this.issue, this.authContext.getLoggedInUser());
        Set<IssueLinkType> linkTypes = linkCollection.getLinkTypes();
        if (linkTypes != null) {
            for (IssueLinkType issueLinkType : linkTypes) {
                List<Issue> inwardIssues;
                List<Issue> outwardIssues = linkCollection.getOutwardIssues(issueLinkType.getName());
                if (outwardIssues != null) {
                    for (Issue issue : outwardIssues) {
                        linkBeans.add(this.buildLink(issueLinkType, issue, true));
                    }
                }
                if ((inwardIssues = linkCollection.getInwardIssues(issueLinkType.getName())) == null) continue;
                for (Issue issue : inwardIssues) {
                    linkBeans.add(this.buildLink(issueLinkType, issue, false));
                }
            }
        }
        return linkBeans;
    }

    private IssueLinkBean buildLink(IssueLinkType issueLinkType, Issue issue, boolean isOutbound) {
        LinkedIssueTypeBean linkedIssueType = LinkedIssueTypeBean.instance().name(issueLinkType.getName()).direction(isOutbound ? LinkedIssueTypeBean.Direction.OUTBOUND : LinkedIssueTypeBean.Direction.INBOUND).description(isOutbound ? issueLinkType.getOutward() : issueLinkType.getInward()).build();
        return this.createIssueLink(issue, linkedIssueType);
    }

    public IssueLinkBean buildParentLink() {
        Issue parent = this.issue.getParentObject();
        if (parent == null) {
            return null;
        }
        LinkedIssueTypeBean linkedIssueType = LinkedIssueTypeBean.instance().name("Parent").direction(LinkedIssueTypeBean.Direction.INBOUND).build();
        return this.createIssueLink(parent, linkedIssueType);
    }

    public List<IssueLinkBean> buildSubtaskLinks() {
        Collection<Issue> subtasks = this.issue.getSubTaskObjects();
        if (subtasks == null) {
            return Collections.emptyList();
        }
        ArrayList<IssueLinkBean> subtaskLinks = new ArrayList<IssueLinkBean>(subtasks.size());
        for (Issue subtask : subtasks) {
            LinkedIssueTypeBean linkedIssueType = LinkedIssueTypeBean.instance().name("Sub-Task").direction(LinkedIssueTypeBean.Direction.OUTBOUND).build();
            subtaskLinks.add(this.createIssueLink(subtask, linkedIssueType));
        }
        return subtaskLinks;
    }

    private IssueLinkBean createIssueLink(Issue issue, LinkedIssueTypeBean linkedIssueType) {
        return new IssueLinkBean(issue.getId(), issue.getKey(), URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "issue/" + issue.getId()), linkedIssueType);
    }
}

