/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json;

import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonData {
    private static ObjectMapper MAPPER = new ObjectMapper();
    private final Object data;

    public JsonData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isNull() {
        return this.data == null;
    }

    public String asString() {
        return this.isString() ? (String)this.data : null;
    }

    public String asString(String fieldName, ErrorCollection errors) {
        if (this.isString()) {
            return (String)this.data;
        }
        errors.addError(fieldName, "expected a string", ErrorCollection.Reason.VALIDATION_FAILED);
        return null;
    }

    public boolean isString() {
        return this.data instanceof String;
    }

    public Map<String, Object> asObject() {
        return this.isObject() ? (Map)this.data : null;
    }

    public boolean isObject() {
        return this.data instanceof Map;
    }

    public boolean isArray() {
        return this.data instanceof List;
    }

    public List<?> asArray() {
        return this.isArray() ? (List)this.data : null;
    }

    public List<String> asArrayOfStrings(boolean allowNulls, String fieldName, ErrorCollection errors) {
        if (!(this.data instanceof List)) {
            errors.addError(fieldName, "data was not an array", ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        List input = (List)this.data;
        int i = 0;
        for (Object o : input) {
            if (o == null && !allowNulls) {
                errors.addError(fieldName, "unexpected null at index " + i, ErrorCollection.Reason.VALIDATION_FAILED);
                return null;
            }
            if (!(o instanceof String)) {
                errors.addError(fieldName, "string expected at index " + i, ErrorCollection.Reason.VALIDATION_FAILED);
                return null;
            }
            ++i;
        }
        return input;
    }

    public List<String> asArrayOfObjectsWithId(String fieldName, ErrorCollection errors) {
        return this.asArrayOfObjectsWithProperty("id", fieldName, errors);
    }

    public String asObjectWithProperty(String propertyname, String fieldName, ErrorCollection errors) {
        if (this.isObject()) {
            return JsonData.asObjectWithProperty(this.data, propertyname, fieldName, errors);
        }
        errors.addError(fieldName, "data was not an object", ErrorCollection.Reason.VALIDATION_FAILED);
        return null;
    }

    public List<String> asArrayOfObjectsWithProperty(String propertyname, String fieldName, ErrorCollection errors) {
        if (!(this.data instanceof List)) {
            errors.addError(fieldName, "data was not an array", ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        List input = (List)this.data;
        ArrayList<String> results = new ArrayList<String>();
        for (Object o : input) {
            String value = JsonData.asObjectWithProperty(o, propertyname, fieldName, errors);
            if (value == null) continue;
            results.add(value);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private static String asObjectWithProperty(Object o, String propertyname, String fieldName, ErrorCollection errors) {
        Object value = JsonData.propertyFromObject(o, propertyname, fieldName, false, errors);
        if (value != null && !(value instanceof String)) {
            errors.addError(fieldName, String.format("expected '%s' property to be a string", propertyname), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        return (String)value;
    }

    private static Object propertyFromObject(Object o, String propertyname, String fieldName, boolean expected, ErrorCollection errors) {
        if (!(o instanceof Map)) {
            errors.addError(fieldName, "expected Object", ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        Map object = (Map)o;
        if (expected && !object.containsKey(propertyname)) {
            errors.addError(fieldName, String.format("expected Object containing an '%s' property", propertyname), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
        return object.get(propertyname);
    }

    public Long getObjectLongProperty(String propertyname, ErrorCollection errors) {
        Object value = JsonData.propertyFromObject(this.data, propertyname, propertyname, false, errors);
        if (errors.hasAnyErrors()) {
            return null;
        }
        if (!(value instanceof Number)) {
            errors.addError(propertyname, "expected a number");
            return null;
        }
        return ((Number)value).longValue();
    }

    public Date getObjectDateProperty(String propertyname, ErrorCollection errors) {
        Object value = JsonData.propertyFromObject(this.data, propertyname, propertyname, false, errors);
        if (errors.hasAnyErrors()) {
            return null;
        }
        if (!(value instanceof String)) {
            errors.addError(propertyname, "expected a string (date)");
            return null;
        }
        String s = (String)value;
        try {
            return Dates.fromTimeString(s);
        }
        catch (IllegalArgumentException e) {
            errors.addError(propertyname, e.getMessage());
            return null;
        }
    }

    public String getObjectStringProperty(String propertyname, String fieldName, ErrorCollection errors) {
        Object value = JsonData.propertyFromObject(this.data, propertyname, fieldName, false, errors);
        if (errors.hasAnyErrors()) {
            return null;
        }
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            errors.addError(propertyname, "expected a string");
            return null;
        }
        return (String)value;
    }

    public <T> T convertValue(String propertyname, Class<T> type, ErrorCollection errors) {
        try {
            return (T)MAPPER.convertValue(this.data, type);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            errors.addError(propertyname, cause == null ? e.getMessage() : e.getCause().getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
            return null;
        }
    }
}

