/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomFieldParser;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.ProjectImportLabelFieldParser;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LabelsCFType
extends AbstractCustomFieldType<Set<Label>, Label>
implements SortableCustomField<Set<Label>>,
ProjectImportableCustomFieldParser,
ProjectImportableCustomField {
    private static final Logger log = Logger.getLogger(LabelsCFType.class);
    private final JiraAuthenticationContext authContext;
    private final IssueManager issueManager;
    private final GenericConfigManager genericConfigManager;
    private final LabelUtil labelUtil;
    private final LabelManager labelManager;
    private final ProjectImportableCustomFieldParser projectImportLabelFieldParser;

    public LabelsCFType(JiraAuthenticationContext authenticationContext, IssueManager issueManager, GenericConfigManager genericConfigManager, LabelUtil labelUtil, LabelManager labelManager, ProjectImportLabelFieldParser projectImportableCustomFieldParser) {
        this.authContext = authenticationContext;
        this.issueManager = issueManager;
        this.genericConfigManager = genericConfigManager;
        this.labelUtil = labelUtil;
        this.labelManager = labelManager;
        this.projectImportLabelFieldParser = projectImportableCustomFieldParser;
    }

    @Override
    @NotNull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> velocityParameters = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue == null || issue.getId() == null) {
            velocityParameters.put("canEdit", Boolean.FALSE);
        } else {
            MutableIssue issueFromDb = this.issueManager.getIssueObject(issue.getId());
            velocityParameters.put("canEdit", this.issueManager.isEditable(issueFromDb, this.authContext.getLoggedInUser()));
            velocityParameters.put("labels", this.getValueFromIssue(field, issue));
        }
        velocityParameters.put("fieldId", field.getId());
        velocityParameters.put("i18n", this.authContext.getI18nHelper());
        velocityParameters.put("field", field);
        velocityParameters.put("labelUtil", this.labelUtil);
        velocityParameters.put("issue", issue);
        velocityParameters.put("labelParser", new LabelParser());
        return velocityParameters;
    }

    @Override
    public Set<Label> getValueFromIssue(CustomField field, Issue issue) {
        Set<Label> labels = this.labelManager.getLabels(issue.getId(), field.getIdAsLong());
        if (labels.isEmpty()) {
            return null;
        }
        return labels;
    }

    @Override
    public Set<Label> getDefaultValue(FieldConfig fieldConfig) {
        Object databaseValue = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (databaseValue != null) {
            try {
                String labelsString = (String)databaseValue;
                return this.convertStringsToLabels(Collections.singleton(labelsString));
            }
            catch (FieldValidationException e) {
                log.error((Object)"Invalid default value encountered", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Set<Label> value) {
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), this.convertLabelsToString(value));
    }

    @Override
    public String getChangelogValue(CustomField field, Set<Label> value) {
        if (value == null) {
            return "";
        }
        return this.convertLabelsToString(value);
    }

    @Override
    public String getStringFromSingularObject(Label singularObject) {
        if (singularObject == null) {
            return null;
        }
        return singularObject.getLabel();
    }

    @Override
    public Label getSingularObjectFromString(String string) throws FieldValidationException {
        if (string == null) {
            return null;
        }
        int labelLength = StringUtils.length((String)string.trim());
        if (LabelParser.isValidLabelName(string) && labelLength <= 255) {
            return new Label(null, null, string);
        }
        if (labelLength > 255) {
            throw new FieldValidationException(this.authContext.getI18nHelper().getText("label.service.error.label.toolong", string));
        }
        throw new FieldValidationException(this.authContext.getI18nHelper().getText("label.service.error.label.invalid", string));
    }

    @Override
    public Set<Long> remove(CustomField field) {
        return this.labelManager.removeLabelsForCustomField(field.getIdAsLong());
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        try {
            this.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException e) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Override
    public void createValue(CustomField field, Issue issue, Set<Label> value) {
        this.setLabels(field, issue, value);
    }

    @Override
    public void updateValue(CustomField field, Issue issue, Set<Label> value) {
        this.setLabels(field, issue, value);
    }

    private void setLabels(CustomField field, Issue issue, Set<Label> value) {
        LinkedHashSet<String> labelStrings = new LinkedHashSet<String>();
        if (value != null) {
            for (Label label : value) {
                labelStrings.add(label.getLabel());
            }
        }
        this.labelManager.setLabels(this.authContext.getLoggedInUser(), issue.getId(), field.getIdAsLong(), labelStrings, false, false);
    }

    @Override
    public Set<Label> getValueFromCustomFieldParams(CustomFieldParams customFieldParams) throws FieldValidationException {
        if (customFieldParams == null || customFieldParams.isEmpty()) {
            return null;
        }
        Collection normalParams = customFieldParams.getValuesForKey(null);
        if (normalParams == null || normalParams.isEmpty()) {
            return null;
        }
        return this.convertStringsToLabels(normalParams);
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection valuesForNullKey = parameters.getValuesForNullKey();
        if (valuesForNullKey != null) {
            StringBuilder ret = new StringBuilder();
            for (String value : valuesForNullKey) {
                ret.append(value).append(" ");
            }
            return ret.toString().trim();
        }
        return null;
    }

    @Override
    public int compare(@NotNull Set<Label> customFieldObjectValue1, @NotNull Set<Label> customFieldObjectValue2, FieldConfig fieldConfig) {
        String stringValue1 = this.convertLabelsToString(customFieldObjectValue1);
        String stringValue2 = this.convertLabelsToString(customFieldObjectValue2);
        if (stringValue1 == null && stringValue2 == null) {
            return 0;
        }
        if (stringValue1 == null) {
            return 1;
        }
        if (stringValue2 == null) {
            return -1;
        }
        return stringValue1.compareTo(stringValue2);
    }

    private String convertLabelsToString(Set<Label> newLabels) {
        if (newLabels == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (Label newLabel : newLabels) {
            ret.append(newLabel).append(" ");
        }
        return ret.toString().trim();
    }

    private Set<Label> convertStringsToLabels(Collection<String> labelStrings) {
        LinkedHashSet<Label> ret = new LinkedHashSet<Label>();
        for (String labelString : labelStrings) {
            if (labelString.length() > 255) {
                throw new FieldValidationException(this.authContext.getI18nHelper().getText("label.service.error.label.toolong", labelString));
            }
            ret.addAll(LabelParser.buildFromString(labelString));
        }
        return ret;
    }

    @Override
    public String getEntityName() {
        return this.projectImportLabelFieldParser.getEntityName();
    }

    @Override
    public ExternalCustomFieldValue parse(Map attributes) throws ParseException {
        return this.projectImportLabelFieldParser.parse(attributes);
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalCustomFieldValue customFieldValue) {
        return this.projectImportLabelFieldParser.getEntityRepresentation(customFieldValue);
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return new LabelCustomFieldImporter();
    }

    @Override
    public boolean valuesEqual(Set<Label> oldLabels, Set<Label> newLabels) {
        if (oldLabels == newLabels) {
            return true;
        }
        if (oldLabels == null && newLabels.isEmpty()) {
            return true;
        }
        if (newLabels == null && oldLabels.isEmpty()) {
            return true;
        }
        return super.valuesEqual(oldLabels, newLabels);
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitLabels(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitLabels(LabelsCFType var1);
    }

    static class LabelCustomFieldImporter
    implements ProjectCustomFieldImporter {
        LabelCustomFieldImporter() {
        }

        @Override
        public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
            MessageSetImpl messageSet = new MessageSetImpl();
            String label = customFieldValue.getValue();
            if (!LabelParser.isValidLabelName(label)) {
                messageSet.addWarningMessage(i18n.getText("label.project.import.error", label));
                messageSet.addWarningMessageInEnglish("Dropping label '" + label + "' because it contains invalid characters.");
            }
            return messageSet;
        }

        @Override
        public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
            String label = customFieldValue.getValue();
            if (LabelParser.isValidLabelName(label)) {
                return new ProjectCustomFieldImporter.MappedCustomFieldValue(label);
            }
            return new ProjectCustomFieldImporter.MappedCustomFieldValue(null);
        }
    }
}

