/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.List;

public class UserIndexInfoResolver
implements IndexInfoResolver<User> {
    private final NameResolver<User> userResolver;

    public UserIndexInfoResolver(NameResolver<User> userResolver) {
        this.userResolver = userResolver;
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        Assertions.notNull("rawValue", rawValue);
        Assertions.notNull("rawValue", rawValue);
        List<String> ids = this.userResolver.getIdsFromName(rawValue);
        if (ids.isEmpty()) {
            return Collections.singletonList(rawValue);
        }
        return ids;
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        Assertions.notNull("rawValue", rawValue);
        return this.getIndexedValues(rawValue.toString());
    }

    @Override
    public String getIndexedValue(User user) {
        Assertions.notNull("user", user);
        return user.getName();
    }
}

