/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;

public class SelectStatisticsMapper
implements StatisticsMapper {
    public static final String RAW_VALUE_SUFFIX = "_raw";
    private final CustomField customField;
    private final ClauseNames clauseNames;
    private final SelectConverter selectConverter;
    private JiraAuthenticationContext authenticationContext;
    private CustomFieldInputHelper customFieldInputHelper;

    public SelectStatisticsMapper(CustomField customField, SelectConverter selectConverter, JiraAuthenticationContext authenticationContext, CustomFieldInputHelper customFieldInputHelper) {
        this.authenticationContext = authenticationContext;
        this.customFieldInputHelper = customFieldInputHelper;
        this.customField = Assertions.notNull("customField", customField);
        this.clauseNames = customField.getClauseNames();
        this.selectConverter = Assertions.notNull("selectConverter", selectConverter);
    }

    protected String getSearchValue(Object value) {
        return this.selectConverter.getString(value);
    }

    @Override
    public String getDocumentConstant() {
        return this.customField.getId() + RAW_VALUE_SUFFIX;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        return this.selectConverter.getObject(documentValue);
    }

    @Override
    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return ((String)o1).compareTo((String)o2);
            }
        };
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return false;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder(searchRequest.getQuery()).where().defaultAnd();
        String clauseName = this.customFieldInputHelper.getUniqueClauseName(this.authenticationContext.getLoggedInUser(), this.clauseNames.getPrimaryName(), this.customField.getName());
        if (value instanceof String) {
            builder.addStringCondition(clauseName, Operator.EQUALS, (String)value);
        } else {
            builder.addEmptyCondition(clauseName);
        }
        return new SearchRequest(builder.buildQuery());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectStatisticsMapper that = (SelectStatisticsMapper)o;
        if (!this.clauseNames.equals(that.clauseNames)) {
            return false;
        }
        return this.customField.getId().equals(that.customField.getId());
    }

    @Override
    public int hashCode() {
        int result = this.customField.getId().hashCode();
        result = 31 * result + this.clauseNames.hashCode();
        return result;
    }
}

