/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.velocity.NumberTool;
import java.util.Map;

public class NumberCFType
extends AbstractSingleFieldType<Double>
implements SortableCustomField<Double>,
ProjectImportableCustomField {
    private final DoubleConverter doubleConverter;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;

    public NumberCFType(CustomFieldValuePersister customFieldValuePersister, DoubleConverter doubleConverter, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.doubleConverter = doubleConverter;
        this.projectCustomFieldImporter = new NoTransformationCustomFieldImporter();
    }

    @Override
    @NotNull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DECIMAL;
    }

    @Override
    public String getStringFromSingularObject(Double customFieldObject) {
        return this.doubleConverter.getString(customFieldObject);
    }

    @Override
    public Double getSingularObjectFromString(String string) throws FieldValidationException {
        return this.doubleConverter.getDouble(string);
    }

    @Override
    public String getChangelogValue(CustomField field, Double value) {
        if (value == null) {
            return "";
        }
        return this.doubleConverter.getStringForChangelog(value);
    }

    @Override
    public int compare(Double customFieldObjectValue1, Double customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    @Override
    protected Object getDbValueFromObject(Double customFieldObject) {
        return customFieldObject;
    }

    @Override
    protected Double getObjectFromDbValue(@NotNull Object databaseValue) throws FieldValidationException {
        return (Double)databaseValue;
    }

    @Override
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> map = super.getVelocityParameters(issue, field, fieldLayoutItem);
        map.put("numberTool", new NumberTool(this.getI18nBean().getLocale()));
        return map;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitNumber(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitNumber(NumberCFType var1);
    }
}

