/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotNullPredicate;

public abstract class AbstractMultiCFType<T>
extends AbstractCustomFieldType<Collection<T>, T> {
    protected final CustomFieldValuePersister customFieldValuePersister;
    protected final GenericConfigManager genericConfigManager;

    protected AbstractMultiCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        this.genericConfigManager = genericConfigManager;
        this.customFieldValuePersister = customFieldValuePersister;
    }

    @Nullable
    protected abstract Comparator<T> getTypeComparator();

    protected abstract Object convertTypeToDbValue(T var1);

    protected abstract T convertDbValueToType(Object var1);

    @NotNull
    protected abstract PersistenceFieldType getDatabaseType();

    @Override
    public Collection<T> getDefaultValue(FieldConfig fieldConfig) {
        Object o = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return this.convertDbObjectToTypes((Collection)o);
        }
        throw new IllegalArgumentException("Value: " + o + " must be a collection. Type not allowed: " + o.getClass());
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Collection<T> value) {
        Collection<Object> names = this.convertTypesToDbObjects(value);
        if (names == null || names.isEmpty()) {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), null);
        } else {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), names);
        }
    }

    @Override
    public void createValue(CustomField customField, Issue issue, Collection<T> value) {
        this.customFieldValuePersister.createValues(customField, issue.getId(), this.getDatabaseType(), this.convertTypesToDbObjects(value));
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, Collection<T> value) {
        this.customFieldValuePersister.updateValues(customField, issue.getId(), this.getDatabaseType(), this.convertTypesToDbObjects(value));
    }

    @Override
    public Collection<T> getValueFromIssue(CustomField field, Issue issue) {
        List<Object> textValues = this.customFieldValuePersister.getValues(field, issue.getId(), this.getDatabaseType());
        return textValues == null || textValues.isEmpty() ? null : this.convertDbObjectToTypes(textValues);
    }

    @Override
    public String getChangelogValue(CustomField field, Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        ArrayList<String> changeLogValues = new ArrayList<String>(values.size());
        for (T singleValue : values) {
            changeLogValues.add(this.getStringFromSingularObject(singleValue));
        }
        return changeLogValues.toString();
    }

    protected final Collection<Object> convertTypesToDbObjects(Collection<T> typedList) {
        if (typedList == null) {
            return Collections.emptyList();
        }
        List<Object> dbObjects = CollectionUtil.transform(typedList, new Function<T, Object>(){

            @Override
            public Object get(T item) {
                return AbstractMultiCFType.this.convertTypeToDbValue(item);
            }
        });
        CollectionUtils.filter(dbObjects, (Predicate)NotNullPredicate.getInstance());
        return dbObjects;
    }

    protected final Collection<T> convertDbObjectToTypes(Collection<Object> dbObjects) {
        if (dbObjects == null) {
            return null;
        }
        HashSet<T> retSet = new HashSet<T>();
        for (Object element : dbObjects) {
            try {
                T value = this.convertDbValueToType(element);
                if (value == null) continue;
                retSet.add(value);
            }
            catch (FieldValidationException ignore) {}
        }
        ArrayList list = new ArrayList(retSet);
        Comparator<T> typeComparator = this.getTypeComparator();
        if (typeComparator != null) {
            Collections.sort(list, typeComparator);
        }
        return list;
    }

    @Override
    public Set<Long> remove(CustomField field) {
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiField(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitMultiField(AbstractMultiCFType var1);
    }
}

