/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class VersionCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;

    public VersionCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, Assertions.notNull("customField", customField));
        this.customField = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    public void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value != null && value instanceof Collection) {
            Collection versions = (Collection)value;
            for (Version version : versions) {
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), version.getId().toString(), Field.Store.YES, indexType));
            }
        }
    }
}

