/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.VersionCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.RequiresProjectSelectedMarker;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.VersionOptionsConfigItem;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.option.GenericImmutableOptions;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class VersionCFType
extends AbstractCustomFieldType
implements MultipleCustomFieldType,
RequiresProjectSelectedMarker,
SortableCustomField,
ProjectImportableCustomField {
    private final Logger log = Logger.getLogger(VersionCFType.class);
    private static final String NO_VERSION_STRING = "-1";
    private static final PersistenceFieldType DB_TYPE = PersistenceFieldType.TYPE_DECIMAL;
    private static final String MULTIPLE_PARAM_KEY = "multiple";
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VersionManager versionManager;
    private final CustomFieldValuePersister persister;
    private final GenericConfigManager genericConfigManager;
    private final VersionHelperBean versionHelperBean;
    private final VersionCustomFieldImporter versionCustomFieldImporter;

    public VersionCFType(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, VersionManager versionManager, CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, VersionHelperBean versionHelperBean) {
        this.permissionManager = permissionManager;
        this.authenticationContext = jiraAuthenticationContext;
        this.versionManager = versionManager;
        this.persister = customFieldValuePersister;
        this.genericConfigManager = genericConfigManager;
        this.versionHelperBean = versionHelperBean;
        this.versionCustomFieldImporter = new VersionCustomFieldImporter();
    }

    public Set remove(CustomField field) {
        return this.persister.removeAllValues(field.getId());
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Collection versionIds = relevantParams.getAllValues();
        if (versionIds != null && versionIds.isEmpty()) {
            CustomField customField = config.getCustomField();
            this.versionHelperBean.validateVersionIds(versionIds, errorCollectionToAddTo, this.getI18nBean(), customField.getId());
        }
    }

    @Override
    public void createValue(CustomField field, Issue issue, Object value) {
        if (value instanceof Collection) {
            this.persister.createValues(field, issue.getId(), DB_TYPE, this.getDbValueFromCollection(value));
        } else {
            this.persister.createValues(field, issue.getId(), DB_TYPE, this.getDbValueFromCollection(EasyList.build((Object)value)));
        }
    }

    @Override
    public void updateValue(CustomField field, Issue issue, Object value) {
        this.persister.updateValues(field, issue.getId(), DB_TYPE, this.getDbValueFromCollection(value));
    }

    @Override
    public Object getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        Collection allValues = parameters.getAllValues();
        Collection collection = CollectionUtils.collect((Collection)allValues, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String versionIdString = (String)input;
                Long versionId = VersionCFType.this.getLongFromString(versionIdString);
                return VersionCFType.this.versionManager.getVersion(versionId);
            }
        });
        if (CustomFieldUtils.isCollectionNotEmpty(collection)) {
            return collection;
        }
        return null;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getAllValues();
    }

    @Override
    public Object getValueFromIssue(CustomField field, Issue issue) {
        List values = this.persister.getValues(field, issue.getId(), DB_TYPE);
        if (values != null && !values.isEmpty()) {
            return this.getVersionFromDoubles(values);
        }
        return null;
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Object value) {
        ArrayList versionIds = this.getDbValueFromCollection(value);
        if (versionIds != null) {
            versionIds = new ArrayList(versionIds);
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), versionIds);
        }
    }

    @Override
    public Object getDefaultValue(FieldConfig fieldConfig) {
        Object o = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        Collection collectionOfDoubles = null;
        if (o instanceof Collection) {
            collectionOfDoubles = (Collection)o;
        } else if (o instanceof Double) {
            collectionOfDoubles = EasyList.build((Object)o);
        }
        if (collectionOfDoubles != null) {
            return this.getVersionFromDoubles(collectionOfDoubles);
        }
        return null;
    }

    @Override
    public String getChangelogValue(CustomField field, Object value) {
        if (value != null) {
            Collection versions = (Collection)value;
            StringBuffer sb = new StringBuffer();
            Iterator iterator = versions.iterator();
            while (iterator.hasNext()) {
                Version version = (Version)iterator.next();
                if (version == null) continue;
                sb.append(version.getId());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public String getChangelogString(CustomField field, Object value) {
        if (value != null) {
            Collection versions = (Collection)value;
            StringBuffer sb = new StringBuffer();
            Iterator iterator = versions.iterator();
            while (iterator.hasNext()) {
                Version version = (Version)iterator.next();
                if (version == null) continue;
                sb.append(version.getName());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getStringFromSingularObject(Object customFieldObject) {
        this.assertObjectImplementsType(Version.class, customFieldObject);
        Version version = (Version)customFieldObject;
        if (version == null) {
            return NO_VERSION_STRING;
        }
        return String.valueOf(version.getId());
    }

    @Override
    public Object getSingularObjectFromString(String string) throws FieldValidationException {
        if (StringUtils.isEmpty((String)string) || NO_VERSION_STRING.equals(string)) {
            return null;
        }
        Long versionId = this.getLongFromString(string);
        return this.versionManager.getVersion(versionId);
    }

    public int compare(Object customFieldObjectValue1, Object customFieldObjectValue2, FieldConfig fieldConfig) {
        if (customFieldObjectValue1 instanceof GenericValue && customFieldObjectValue2 instanceof GenericValue) {
            this.log.debug((Object)"Comparing generic values instead of versions!");
            return OfBizComparators.NAME_COMPARATOR.compare((GenericValue)customFieldObjectValue1, (GenericValue)customFieldObjectValue2);
        }
        if (customFieldObjectValue1 instanceof Version && customFieldObjectValue2 instanceof Version) {
            return new VersionComparator().compare((Version)customFieldObjectValue1, (Version)customFieldObjectValue2);
        }
        throw new IllegalArgumentException("The objects are not of the expected type.");
    }

    @Override
    public List getConfigurationItemTypes() {
        List<FieldConfigItemType> configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new VersionOptionsConfigItem(this.versionManager));
        return configurationItemTypes;
    }

    @Override
    public Options getOptions(FieldConfig config, JiraContextNode jiraContextNode) {
        if (jiraContextNode != null && jiraContextNode.getProject() != null) {
            return new GenericImmutableOptions(this.versionManager.getVersions(jiraContextNode.getProject()), config);
        }
        return new GenericImmutableOptions(Collections.EMPTY_LIST, config);
    }

    @Override
    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (!bulkEditBean.isMultipleProjects() && bulkEditBean.getProject() != null) {
            if (this.versionManager.getVersions(bulkEditBean.getProject()).isEmpty()) {
                return "bulk.edit.unavailable.noversions";
            }
            return null;
        }
        return "bulk.edit.unavailable.multipleprojects";
    }

    @Override
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map<String, Object> velocityParameters = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (issue != null) {
            Collection<Version> releasedversion = this.versionManager.getVersionsReleasedDesc(issue.getProject(), false);
            Collection<Version> unreleasedversion = this.versionManager.getVersionsUnreleased(issue.getProject(), false);
            Collection currentlySelectedArchivedVersions = this.getCurrentlySelectedArchivedVersions(issue, field);
            velocityParameters.put("unknownVersionId", -1L);
            velocityParameters.put("releasedVersion", releasedversion);
            velocityParameters.put("unreleasedVersion", unreleasedversion);
            velocityParameters.put("archivedVersions", currentlySelectedArchivedVersions);
            if (fieldLayoutItem != null) {
                velocityParameters.put("isFrotherControl", HackyRendererType.fromKey(fieldLayoutItem.getRendererType()) == HackyRendererType.FROTHER_CONTROL);
            }
        }
        velocityParameters.put("collection", new CollectionUtils());
        velocityParameters.put(MULTIPLE_PARAM_KEY, Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY)));
        return velocityParameters;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.versionCustomFieldImporter;
    }

    public boolean isMultiple() {
        return Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY));
    }

    private Collection getCurrentlySelectedArchivedVersions(Issue issue, CustomField field) {
        Collection selectedVersions = (Collection)this.getValueFromIssue(field, issue);
        if (selectedVersions != null && !selectedVersions.isEmpty()) {
            return CollectionUtils.select((Collection)selectedVersions, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Version version = (Version)object;
                    return version.isArchived();
                }
            });
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getDbValueFromCollection(Object value) {
        if (value != null) {
            Collection collection = (Collection)value;
            Collection verisionIdDoubles = CollectionUtils.collect((Collection)collection, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    if (input != null) {
                        Version version = (Version)input;
                        return new Double(version.getId().longValue());
                    }
                    return null;
                }
            });
            return CollectionUtils.select((Collection)verisionIdDoubles, (Predicate)NotNullPredicate.getInstance());
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getVersionFromDoubles(Collection collectionOfDoubles) {
        Collection collection = CollectionUtils.collect((Collection)collectionOfDoubles, (Transformer)new Transformer(){

            public Object transform(Object input) {
                if (input != null) {
                    Double versionIdDouble = (Double)input;
                    Long versionId = new Long(versionIdDouble.longValue());
                    return VersionCFType.this.versionManager.getVersion(versionId);
                }
                return null;
            }
        });
        CollectionUtils.filter((Collection)collection, (Predicate)NotNullPredicate.getInstance());
        return collection;
    }

    private Long getLongFromString(String stringValue) throws FieldValidationException {
        try {
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Version Id is not a number '" + stringValue + "'");
        }
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitVersion(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitVersion(VersionCFType var1);
    }
}

