/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;

public class JiraUrl
extends HttpURL {
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";

    public JiraUrl(String baseUrl) throws URIException {
        super(baseUrl);
    }

    public void setQuery(List<NameValuePair> nameValuePairs) throws URIException {
        if (nameValuePairs == null || nameValuePairs.isEmpty()) {
            super.setQuery(null);
        } else {
            String[] names = new String[nameValuePairs.size()];
            String[] values = new String[nameValuePairs.size()];
            for (int i = 0; i < nameValuePairs.size(); ++i) {
                NameValuePair nvp = nameValuePairs.get(i);
                names[i] = nvp.getName();
                values[i] = nvp.getValue();
            }
            super.setQuery(names, values);
        }
    }

    public static String constructBaseUrl(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        String scheme = request.getScheme();
        sb.append(scheme);
        sb.append("://");
        sb.append(request.getServerName());
        int port = request.getServerPort();
        if (!JiraUrl.isStandardPort(scheme, port)) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME) && port == 80) {
            return true;
        }
        return scheme.equalsIgnoreCase(HTTPS_SCHEME) && port == 443;
    }

    public static String extractActionFromURL(String url) {
        if (url.contains(".jspa")) {
            url = url.substring(url.lastIndexOf("/"));
        }
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        return url;
    }
}

