/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class GroupRoleActorFactory
implements RoleActorFactory {
    public static final String TYPE = "atlassian-group-role-actor";
    private static final Logger log = Logger.getLogger(GroupRoleActorFactory.class);
    private final CrowdService crowdService;
    private final GroupManager groupManager;

    public GroupRoleActorFactory(CrowdService crowdService, GroupManager groupManager) {
        this.crowdService = crowdService;
        this.groupManager = groupManager;
    }

    @Override
    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String groupName) throws RoleActorDoesNotExistException {
        if (!TYPE.equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        Group group = this.crowdService.getGroup(groupName);
        if (group == null) {
            throw new RoleActorDoesNotExistException("Group '" + groupName + "' does not exist.");
        }
        return new GroupRoleActor(id, projectRoleId, projectId, group);
    }

    public Set optimizeRoleActorSet(Set roleActors) {
        return roleActors;
    }

    public class GroupRoleActor
    extends AbstractRoleActor {
        private final Group group;

        GroupRoleActor(Long id, Long projectRoleId, Long projectId, Group group) {
            super(id, projectRoleId, projectId, group.getName());
            this.group = group;
        }

        @Override
        public String getType() {
            return GroupRoleActorFactory.TYPE;
        }

        @Override
        public String getDescriptor() {
            return this.getParameter();
        }

        @Override
        public Set<User> getUsers() {
            HashSet<User> users = new HashSet<User>();
            for (User user : GroupRoleActorFactory.this.groupManager.getUsersInGroup(this.group.getName())) {
                users.add(user);
            }
            return users;
        }

        @Override
        public boolean contains(User user) {
            if (user == null) {
                return false;
            }
            return GroupRoleActorFactory.this.crowdService.isUserMemberOfGroup(user, this.group);
        }

        public Group getGroup() throws IllegalArgumentException {
            return this.group;
        }
    }
}

