/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.versionpanel.impl;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanel;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanelModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.query.clause.Clause;
import java.util.HashMap;
import java.util.Map;

public class GenericTabPanel
implements VersionTabPanel {
    private VersionTabPanelModuleDescriptor descriptor;
    protected final JiraAuthenticationContext authenticationContext;
    protected final SearchProvider searchProvider;
    private final FieldVisibilityManager fieldVisibilityManager;

    public GenericTabPanel(JiraAuthenticationContext authenticationContext, SearchProvider searchProvider, FieldVisibilityManager fieldVisibilityManager) {
        this.authenticationContext = authenticationContext;
        this.searchProvider = searchProvider;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Deprecated
    public GenericTabPanel(JiraAuthenticationContext authenticationContext, SearchProvider searchProvider) {
        this(authenticationContext, searchProvider, ComponentAccessor.getComponent(FieldVisibilityManager.class));
    }

    @Override
    public void init(VersionTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getHtml(BrowseVersionContext context) {
        Map<String, Object> startingParams = this.createVelocityParams(context);
        return this.descriptor.getHtml("view", startingParams);
    }

    protected StatisticAccessorBean createStatisticAccessorBean(BrowseVersionContext context, boolean limitToUnresolved) {
        Clause searchClause = JqlQueryBuilder.newClauseBuilder().fixVersion().eq(context.getVersion().getId()).buildClause();
        return new StatisticAccessorBean(this.authenticationContext.getUser(), context.getProject().getId(), searchClause, limitToUnresolved);
    }

    protected Map<String, Object> createVelocityParams(BrowseVersionContext context) {
        HashMap<String, Object> startingParams = new HashMap<String, Object>();
        startingParams.put("project", context.getProject());
        startingParams.put("versionContext", context);
        return startingParams;
    }

    @Override
    public boolean showPanel(BrowseVersionContext context) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(context.getProject().getId(), "fixVersions");
    }
}

