/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilderFactory;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.util.NotNull;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class JqlQueryBuilder {
    private final JqlOrderByBuilder jqlOrderByBuilder;
    private final JqlClauseBuilder jqlClauseBuilder;

    @NotNull
    public static JqlQueryBuilder newBuilder() {
        return new JqlQueryBuilder();
    }

    @NotNull
    public static JqlQueryBuilder newBuilder(Query existingQuery) {
        return new JqlQueryBuilder(existingQuery);
    }

    @NotNull
    public static JqlClauseBuilder newClauseBuilder() {
        return JqlQueryBuilder.createClauseBuilder(null, null);
    }

    @NotNull
    public static JqlClauseBuilder newClauseBuilder(Clause copy) {
        return JqlQueryBuilder.createClauseBuilder(null, copy);
    }

    @NotNull
    public static JqlClauseBuilder newClauseBuilder(Query query) {
        return JqlQueryBuilder.createClauseBuilder(null, query == null ? null : query.getWhereClause());
    }

    @NotNull
    public static JqlOrderByBuilder newOrderByBuilder() {
        return new JqlOrderByBuilder(null);
    }

    @NotNull
    public static JqlOrderByBuilder newOrderByBuilder(OrderBy copy) {
        return JqlQueryBuilder.createOrderByBuilder(null, copy);
    }

    @NotNull
    public static JqlOrderByBuilder newOrderByBuilder(Query query) {
        return JqlQueryBuilder.createOrderByBuilder(null, query == null ? null : query.getOrderByClause());
    }

    private JqlQueryBuilder() {
        this.jqlOrderByBuilder = JqlQueryBuilder.createOrderByBuilder(this, null);
        this.jqlClauseBuilder = JqlQueryBuilder.createClauseBuilder(this, null);
    }

    private JqlQueryBuilder(Query existingQuery) {
        Clause exisitingClause = null;
        OrderBy exisitngOrderBy = null;
        if (existingQuery != null) {
            exisitingClause = existingQuery.getWhereClause();
            exisitngOrderBy = existingQuery.getOrderByClause();
        }
        this.jqlClauseBuilder = JqlQueryBuilder.createClauseBuilder(this, exisitingClause);
        this.jqlOrderByBuilder = JqlQueryBuilder.createOrderByBuilder(this, exisitngOrderBy);
    }

    @NotNull
    public JqlOrderByBuilder orderBy() {
        return this.jqlOrderByBuilder;
    }

    @NotNull
    public JqlClauseBuilder where() {
        return this.jqlClauseBuilder;
    }

    @NotNull
    public Query buildQuery() {
        Clause whereClause = this.jqlClauseBuilder.buildClause();
        OrderBy orderByClause = this.jqlOrderByBuilder.buildOrderBy();
        return new QueryImpl(whereClause, orderByClause, null);
    }

    public JqlQueryBuilder clear() {
        this.where().clear();
        this.orderBy().clear();
        return this;
    }

    private static JqlClauseBuilder createClauseBuilder(JqlQueryBuilder parent, Clause copy) {
        JqlClauseBuilder jqlClauseBuilder = ComponentAccessor.getComponent(JqlClauseBuilderFactory.class).newJqlClauseBuilder(parent);
        if (copy != null) {
            jqlClauseBuilder.addClause(copy);
        }
        return jqlClauseBuilder;
    }

    private static JqlOrderByBuilder createOrderByBuilder(JqlQueryBuilder parent, OrderBy copy) {
        JqlOrderByBuilder builder = new JqlOrderByBuilder(parent);
        if (copy != null) {
            builder.setSorts(copy);
        }
        return builder;
    }
}

