/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.SelectCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.config.item.SettableOptionsConfigItem;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.converters.StringConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.TextCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.OptionUtils;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SelectCFType
extends TextCFType
implements MultipleSettableCustomFieldType,
MultipleCustomFieldType,
SortableCustomField<String>,
GroupSelectorField {
    private final OptionsManager optionsManager;
    private final ProjectCustomFieldImporter projectCustomFieldImporter;
    private static final Logger log = Logger.getLogger(SelectCFType.class);

    public SelectCFType(CustomFieldValuePersister customFieldValuePersister, StringConverter stringConverter, SelectConverter selectConverter, OptionsManager optionsManager, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, stringConverter, genericConfigManager);
        this.optionsManager = optionsManager;
        this.projectCustomFieldImporter = new SelectCustomFieldImporter();
    }

    @Override
    public Set remove(CustomField field) {
        Set issues = super.remove(field);
        this.optionsManager.removeCustomFieldOptions(field);
        return issues;
    }

    @Override
    public void removeValue(CustomField field, Issue issue, Option option) {
        this.updateValue(field, issue, null);
    }

    @Override
    public Object getSingularObjectFromString(String string) throws FieldValidationException {
        if ("-1".equals(string)) {
            return null;
        }
        return this.getOptionFromStringValue(string);
    }

    private Option getOptionFromStringValue(String selectValue) throws FieldValidationException {
        Long aLong = OptionUtils.safeParseLong(selectValue);
        if (aLong != null) {
            Option option = this.optionsManager.findByOptionId(aLong);
            if (option != null) {
                return option;
            }
            return null;
        }
        return null;
    }

    @Override
    public String getStringFromSingularObject(Object optionObject) {
        if (optionObject == null) {
            return null;
        }
        if (optionObject instanceof Option) {
            Option option = (Option)optionObject;
            return option.getOptionId().toString();
        }
        log.warn((Object)("Object passed '" + optionObject + "' is not an Option but " + optionObject != null ? " of type " + optionObject.getClass() : " is null"));
        return null;
    }

    @Override
    public Set getIssueIdsWithValue(CustomField field, Option option) {
        if (option != null) {
            return this.customFieldValuePersister.getIssueIdsWithValue(field, PersistenceFieldType.TYPE_LIMITED_TEXT, option.getOptionId().toString());
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public List getConfigurationItemTypes() {
        List<FieldConfigItemType> configurationItemTypes = super.getConfigurationItemTypes();
        configurationItemTypes.add(new SettableOptionsConfigItem(this, this.optionsManager));
        return configurationItemTypes;
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        String selectedString = (String)relevantParams.getFirstValueForNullKey();
        if (StringUtils.isNotBlank((String)selectedString) && !"-1".equals(selectedString)) {
            Options options = this.optionsManager.getOptions(config);
            CustomField customField = config.getCustomField();
            String validOptions = this.createValidOptionsString(options);
            Long optionId = null;
            try {
                optionId = Long.valueOf(selectedString);
            }
            catch (NumberFormatException e) {
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + selectedString + "'", "'" + customField + "'", validOptions));
            }
            if (options != null && options.getOptionById(optionId) == null) {
                errorCollectionToAddTo.addError(customField.getId(), this.getI18nBean().getText("admin.errors.invalid.value.passed.for.customfield", "'" + selectedString + "'", "'" + customField + "'", validOptions));
            }
        }
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, Object value) {
        Option option = (Option)value;
        Long id = null;
        if (option != null) {
            id = option.getOptionId();
        }
        this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), id);
    }

    @Override
    public Object getDefaultValue(FieldConfig fieldConfig) {
        ArrayList options = new ArrayList();
        Long optionId = (Long)this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
        if (optionId == null) {
            return null;
        }
        return this.optionsManager.findByOptionId(optionId);
    }

    @Override
    public Object getValueFromIssue(CustomField field, Issue issue) {
        List values = this.customFieldValuePersister.getValues(field, issue.getId(), PersistenceFieldType.TYPE_LIMITED_TEXT);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object value = values.iterator().next();
        return this.getSingularObjectFromString((String)value);
    }

    @Override
    public String getChangelogString(CustomField field, Object value) {
        return value == null ? null : ((Option)value).getValue();
    }

    private String createValidOptionsString(Options options) {
        List rootOptions = options.getRootOptions();
        StringBuffer validOptions = new StringBuffer();
        Iterator optionIterator = rootOptions.iterator();
        while (optionIterator.hasNext()) {
            Object obj = optionIterator.next();
            if (obj instanceof Option) {
                Option option = (Option)obj;
                validOptions.append(option.getOptionId() + "[" + option.getValue() + "]");
            } else {
                validOptions.append(obj.toString());
            }
            if (!optionIterator.hasNext()) continue;
            validOptions.append(", ");
        }
        validOptions.append(", -1");
        return validOptions.toString();
    }

    @Override
    public Options getOptions(FieldConfig config, JiraContextNode jiraContextNode) {
        return this.optionsManager.getOptions(config);
    }

    @Override
    public int compare(String customFieldObjectValue1, String customFieldObjectValue2, FieldConfig fieldConfig) {
        Options options = this.getOptions(fieldConfig, null);
        if (options != null) {
            int v2;
            int v1 = options.indexOf(options.getOptionById(Long.valueOf(customFieldObjectValue1)));
            if (v1 > (v2 = options.indexOf(options.getOptionById(Long.valueOf(customFieldObjectValue2))))) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
        log.info((Object)"No options were found.");
        return 0;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitSelect(this);
        }
        return super.accept(visitor);
    }

    @Override
    public Query getQueryForGroup(String fieldID, String groupName) {
        return new TermQuery(new Term(fieldID + "_raw", groupName));
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitSelect(SelectCFType var1);
    }
}

