/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.util.AttachmentException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AttachmentUtils {
    private static final Logger log = Logger.getLogger(AttachmentUtils.class);
    private static final String THUMBNAIL_DESIGNATION = "_thumb_";
    private static final String TMP_ATTACHMENTS = "tmp_attachments";
    public static final String THUMBS_SUBDIR = "thumbs";

    public static File getThumbnailDirectory(Issue issue) {
        File thumbDir = new File(AttachmentUtils.getAttachmentDirectory(issue), THUMBS_SUBDIR);
        if (!thumbDir.exists() && !thumbDir.mkdirs()) {
            log.warn((Object)("Unable to make thumbnail directory " + thumbDir.getAbsolutePath()));
        }
        return thumbDir;
    }

    public static File getAttachmentDirectory(Issue issue) {
        return AttachmentUtils.getAttachmentDirectory(issue, true);
    }

    public static File getAttachmentDirectory(Issue issue, boolean createDirectory) {
        Project project = issue.getProjectObject();
        return AttachmentUtils.getAttachmentDirectory(project.getKey(), issue.getKey(), createDirectory);
    }

    public static File getTemporaryAttachmentDirectory() {
        File cachesDirectory = ComponentAccessor.getComponent(JiraHome.class).getCachesDirectory();
        File tempDirectory = new File(cachesDirectory, TMP_ATTACHMENTS);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        return tempDirectory;
    }

    private static File getAttachmentDirectory(String projectKey, String issueKey, boolean createDirectory) {
        File directory = AttachmentUtils.getAttachmentDirectory(AttachmentUtils.getAttachmentDirName(), projectKey, issueKey);
        if (createDirectory) {
            directory.mkdirs();
        }
        return directory;
    }

    public static File getAttachmentDirectory(String attachmentDirectory, String projectKey, String issueKey) {
        File projectDirectory = new File(attachmentDirectory, projectKey);
        return new File(projectDirectory, issueKey);
    }

    public static File getAttachmentFile(Attachment attachment) throws DataAccessException {
        File attachmentDir = AttachmentUtils.getAttachmentDirectory(attachment.getIssueObject());
        return AttachmentUtils.getAttachmentFile(AttachmentAdapter.fromAttachment(attachment), attachmentDir);
    }

    public static File getAttachmentFile(AttachmentAdapter attachment, File attachmentDir) {
        File legacyFile = AttachmentUtils.getLegacyAttachmentFile(attachment, attachmentDir);
        File defaultFile = AttachmentUtils.getDefaultAttachmentFile(attachment, attachmentDir);
        if (defaultFile.exists()) {
            return defaultFile;
        }
        if (legacyFile.exists()) {
            return legacyFile;
        }
        File legacyAttachmentById = AttachmentUtils.findLegacyAttachmentById(attachment, attachmentDir);
        if (legacyAttachmentById == null) {
            return defaultFile;
        }
        return legacyAttachmentById;
    }

    public static File getThumbnailFile(Attachment attachment) {
        AttachmentAdapter attachmentAdapter = AttachmentAdapter.fromAttachment(attachment);
        File thumbDir = AttachmentUtils.getThumbnailDirectory(attachment.getIssueObject());
        return AttachmentUtils.getThumbnailFile(attachmentAdapter, thumbDir);
    }

    public static File getLegacyThumbnailFile(Attachment attachment) {
        AttachmentAdapter attachmentAdapter = AttachmentAdapter.fromAttachment(attachment);
        File thumbDir = AttachmentUtils.getThumbnailDirectory(attachment.getIssueObject());
        return AttachmentUtils.getLegacyThumbnailFile(attachmentAdapter, thumbDir);
    }

    public static void checkValidAttachmentDirectory(Issue issue) throws AttachmentException {
        try {
            File directory = AttachmentUtils.getAttachmentDirectory(issue);
            if (!directory.canWrite()) {
                throw new AttachmentException(ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()).getText("attachfile.error.writeerror", directory.getAbsolutePath()));
            }
            AttachmentUtils.checkValidTemporaryAttachmentDirectory();
        }
        catch (Exception e) {
            throw new AttachmentException(ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()).getText("attachfile.error.exception", e.toString()), e);
        }
    }

    public static void checkValidTemporaryAttachmentDirectory() throws AttachmentException {
        File tempDirectory = AttachmentUtils.getTemporaryAttachmentDirectory();
        if (!tempDirectory.canWrite()) {
            throw new AttachmentException(ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()).getText("attachfile.error.temp.writeerror", tempDirectory.getAbsolutePath()));
        }
    }

    private static String getAttachmentDirName() {
        return ComponentAccessor.getAttachmentPathManager().getAttachmentPath();
    }

    private static File findLegacyAttachmentById(AttachmentAdapter attachment, File attachmentDir) {
        final Pattern allFilesPattern = Pattern.compile("^" + attachment.getId() + "_.+");
        File[] list = attachmentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher m = allFilesPattern.matcher(name);
                return m.matches();
            }
        });
        if (list == null || list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            Pattern thumbnailExcludingPattern = Pattern.compile("^" + attachment.getId() + "_(?!thumb_).+");
            File firstFile = null;
            int matchCount = 0;
            for (File file : list) {
                if (!thumbnailExcludingPattern.matcher(file.getName()).matches()) continue;
                ++matchCount;
                if (firstFile != null) continue;
                firstFile = file;
            }
            if (matchCount == 1) {
                return firstFile;
            }
            log.warn((Object)("More than one file found for attachment id " + attachment.getId() + " in " + attachmentDir + ". The first entry will be returned."));
        }
        return list[0];
    }

    private static File getThumbnailFile(AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, THUMBNAIL_DESIGNATION + attachment.getId() + ".png");
    }

    private static File getLegacyThumbnailFile(AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId() + THUMBNAIL_DESIGNATION + attachment.getFilename());
    }

    private static File getDefaultAttachmentFile(AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId().toString());
    }

    private static File getLegacyAttachmentFile(AttachmentAdapter attachment, File attachmentDir) {
        return new File(attachmentDir, attachment.getId() + "_" + attachment.getFilename());
    }

    public static class AttachmentAdapter {
        private final Long id;
        private final String name;

        public AttachmentAdapter(Long id, String name) {
            this.id = id;
            this.name = name;
        }

        public Long getId() {
            return this.id;
        }

        public String getFilename() {
            return this.name;
        }

        static AttachmentAdapter fromAttachment(Attachment attachment) {
            return new AttachmentAdapter(attachment.getId(), attachment.getFilename());
        }
    }
}

