/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.jira.imports.project.customfield.NoTransformationCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.StringCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.opensymphony.util.UrlUtils;

public class URLCFType
extends StringCFType
implements SortableCustomField<String>,
ProjectImportableCustomField {
    private final ProjectCustomFieldImporter projectCustomFieldImporter = new NoTransformationCustomFieldImporter();

    public URLCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, genericConfigManager);
    }

    @Override
    public String getStringFromSingularObject(Object value) {
        return (String)value;
    }

    @Override
    public Object getSingularObjectFromString(String string) throws FieldValidationException {
        String uri;
        String string2 = uri = string == null ? null : string.trim();
        if (!UrlUtils.verifyHierachicalURI((String)uri)) {
            throw new FieldValidationException("Not a valid URL");
        }
        return uri;
    }

    @Override
    public int compare(String customFieldObjectValue1, String customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    @Override
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    @Override
    public ProjectCustomFieldImporter getProjectImporter() {
        return this.projectCustomFieldImporter;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitURL(this);
        }
        return super.accept(visitor);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitURL(URLCFType var1);
    }
}

