/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.jira.issue.context.AbstractJiraContext;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectCategoryContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class GlobalIssueContext
extends AbstractJiraContext {
    public static final String GLOBAL_CONTEXT_STR = "Global Context";
    private List<JiraContextNode> children = null;
    private final JiraContextTreeManager treeManager;

    public GlobalIssueContext(JiraContextTreeManager treeManager) {
        this.treeManager = treeManager;
    }

    @Override
    public Map<String, Object> appendToParamsMap(Map<String, Object> input) {
        return MapBuilder.newBuilder(input).add("projectcategory", null).add("project", null).toMap();
    }

    @Override
    public IssueType getIssueTypeObject() {
        return null;
    }

    @Override
    public GenericValue getIssueType() {
        return null;
    }

    @Override
    public Project getProjectObject() {
        return null;
    }

    @Override
    public GenericValue getProject() {
        return null;
    }

    @Override
    public GenericValue getProjectCategory() {
        return null;
    }

    @Override
    public boolean isInContext(IssueContext issueContext) {
        return true;
    }

    public BandanaContext getParentContext() {
        return null;
    }

    public boolean hasParentContext() {
        return false;
    }

    public static JiraContextNode getInstance() {
        return JiraContextTreeManager.getRootContext();
    }

    @Override
    public String toString() {
        return GLOBAL_CONTEXT_STR;
    }

    @Override
    public List<JiraContextNode> getChildContexts() {
        Collection<GenericValue> projectCategories;
        if (this.children == null && (projectCategories = this.treeManager.getProjectManager().getProjectCategories()) != null) {
            this.children = new ArrayList<JiraContextNode>(projectCategories.size() + 1);
            for (GenericValue projectCategory : projectCategories) {
                this.children.add(new ProjectCategoryContext(projectCategory, this.treeManager));
            }
            this.children.add(new ProjectCategoryContext(null, this.treeManager));
        }
        return this.children;
    }
}

