/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.report;

import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.util.ChartReportUtils;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.charts.util.DataUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.ProjectActionSupport;
import java.util.Map;

public abstract class AbstractChartReport
extends AbstractReport {
    private static final String PROJECT_OR_FILTER_ID = "projectOrFilterId";
    private final ProjectManager projectManager;
    private final SearchRequestService searchRequestService;
    protected final JiraAuthenticationContext authenticationContext;
    protected final ApplicationProperties applicationProperties;
    protected final ChartUtils chartUtils;
    private static final String DAYSPREVIOUS = "daysprevious";
    private static final String PERIOD = "periodName";

    protected AbstractChartReport(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, ProjectManager projectManager, SearchRequestService searchRequestService, ChartUtils chartUtils) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.searchRequestService = searchRequestService;
        this.chartUtils = chartUtils;
    }

    @Override
    public void validate(ProjectActionSupport action, Map params) {
        this.validateDaysPrevious(action, params);
        this.validateProjectOrFilterId(action, params);
    }

    protected void validateProjectOrFilterId(ProjectActionSupport action, Map params) {
        String projectOrFilterId = (String)params.get(PROJECT_OR_FILTER_ID);
        if (ChartReportUtils.isValidProjectParamFormat(projectOrFilterId)) {
            this.validateProjectId(action, ChartReportUtils.extractProjectOrFilterId(projectOrFilterId));
        } else if (ChartReportUtils.isValidFilterParamFormat(projectOrFilterId)) {
            this.validateFilterId(action, ChartReportUtils.extractProjectOrFilterId(projectOrFilterId));
        } else {
            action.addError(PROJECT_OR_FILTER_ID, action.getText("report.error.no.filter.or.project"));
        }
    }

    private void validateProjectId(ProjectActionSupport action, String projectId) {
        try {
            Project project = this.projectManager.getProjectObj(new Long(projectId));
            if (project == null) {
                action.addError(PROJECT_OR_FILTER_ID, action.getText("report.error.project.id.not.found", projectId));
            }
        }
        catch (NumberFormatException nfe) {
            action.addError(PROJECT_OR_FILTER_ID, action.getText("report.error.project.id.not.a.number", projectId));
        }
    }

    private void validateFilterId(ProjectActionSupport action, String filterId) {
        try {
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(action.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection());
            SearchRequest searchRequest = this.searchRequestService.getFilter(serviceContext, new Long(filterId));
            if (searchRequest == null) {
                action.addError(PROJECT_OR_FILTER_ID, action.getText("report.error.no.filter", filterId));
            }
        }
        catch (NumberFormatException nfe) {
            action.addError(PROJECT_OR_FILTER_ID, action.getText("report.error.filter.id.not.a.number", filterId));
        }
    }

    protected void validateDaysPrevious(ProjectActionSupport action, Map params) {
        String daysprevious = (String)params.get(DAYSPREVIOUS);
        String period = (String)params.get(PERIOD);
        try {
            int days = Integer.parseInt(daysprevious);
            if (days < 1) {
                action.addError(DAYSPREVIOUS, action.getText("report.error.days.previous"));
                return;
            }
            int normalizedDays = DataUtils.normalizeDaysValue(days, ChartFactory.PeriodName.valueOf(period));
            if (normalizedDays != days) {
                action.addError(DAYSPREVIOUS, action.getText("report.error.days.previous.period", normalizedDays));
            }
        }
        catch (NumberFormatException nfe) {
            action.addError(DAYSPREVIOUS, action.getText("report.error.days.previous.not.a.number"));
        }
    }
}

