/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;

public enum ClausePrecedence {
    OR(700),
    AND(1000),
    NOT(2000),
    TERMINAL(Integer.MAX_VALUE);

    private final int value;

    public static ClausePrecedence getPrecedence(Clause clause) {
        if (clause instanceof AndClause) {
            return AND;
        }
        if (clause instanceof OrClause) {
            return OR;
        }
        if (clause instanceof NotClause) {
            return NOT;
        }
        if (clause instanceof TerminalClause || clause instanceof ChangedClause) {
            return TERMINAL;
        }
        throw new IllegalArgumentException("Attempt to get precedence for an unsupported clause.");
    }

    private ClausePrecedence(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }
}

