/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.operand;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MultiValueOperand
implements Operand {
    public static final String OPERAND_NAME = "MultiValueOperand";
    private final List<Operand> values;
    private static final String LEFT_PAREN = "(";
    private static final String COMMA_SPACE = ", ";
    private static final String RIGHT_PAREN = ")";

    public static MultiValueOperand ofQueryLiterals(Collection<QueryLiteral> literals) {
        return new MultiValueOperand(literals.toArray(new QueryLiteral[literals.size()]));
    }

    public MultiValueOperand(String ... stringValues) {
        Assertions.notNull("stringValues", stringValues);
        Assertions.not("stringValues is empty", stringValues.length == 0);
        ArrayList<SingleValueOperand> tmpValues = new ArrayList<SingleValueOperand>(stringValues.length);
        for (String stringValue : stringValues) {
            SingleValueOperand singleValueOperand = new SingleValueOperand(stringValue);
            tmpValues.add(singleValueOperand);
        }
        this.values = Collections.unmodifiableList(tmpValues);
    }

    public MultiValueOperand(Long ... longs) {
        Assertions.notNull("longs", longs);
        Assertions.not("longs not empty", longs.length == 0);
        ArrayList<SingleValueOperand> tmpValues = new ArrayList<SingleValueOperand>(longs.length);
        for (Long longValue : longs) {
            SingleValueOperand singleValueOperand = new SingleValueOperand(longValue);
            tmpValues.add(singleValueOperand);
        }
        this.values = Collections.unmodifiableList(tmpValues);
    }

    public MultiValueOperand(Operand ... operands) {
        this(Arrays.asList((Object[])Assertions.notNull("operands", operands)));
    }

    public MultiValueOperand(QueryLiteral ... literals) {
        Assertions.notNull("literals", literals);
        Assertions.not("literals not empty", literals.length == 0);
        ArrayList<Operand> tmpValues = new ArrayList<Operand>(literals.length);
        for (QueryLiteral literal : literals) {
            if (literal.isEmpty()) {
                tmpValues.add(EmptyOperand.EMPTY);
                continue;
            }
            SingleValueOperand singleValueOperand = new SingleValueOperand(literal);
            tmpValues.add(singleValueOperand);
        }
        this.values = Collections.unmodifiableList(tmpValues);
    }

    public MultiValueOperand(Collection<? extends Operand> values) {
        Assertions.containsNoNulls("values", values);
        Assertions.not("values is empty", values.isEmpty());
        this.values = CollectionUtil.copyAsImmutableList(values);
    }

    public List<Operand> getValues() {
        return this.values;
    }

    @Override
    public String getName() {
        return OPERAND_NAME;
    }

    @Override
    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LEFT_PAREN);
        Iterator<Operand> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Operand value = iterator.next();
            sb.append(value.getDisplayString());
            if (!iterator.hasNext()) continue;
            sb.append(COMMA_SPACE);
        }
        sb.append(RIGHT_PAREN);
        return sb.toString();
    }

    @Override
    public <R> R accept(OperandVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValueOperand that = (MultiValueOperand)o;
        return !(this.values != null ? !((Object)this.values).equals(that.values) : that.values != null);
    }

    public int hashCode() {
        return this.values != null ? ((Object)this.values).hashCode() : 0;
    }
}

