/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.order;

import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OrderByImpl
implements OrderBy {
    public static final OrderByImpl NO_ORDER = new OrderByImpl(Collections.<SearchSort>emptyList());
    private final List<SearchSort> searchSorts;

    public OrderByImpl(SearchSort ... searchSorts) {
        this(Arrays.asList((Object[])Assertions.notNull("searchSorts", searchSorts)));
    }

    public OrderByImpl(Collection<SearchSort> searchSorts) {
        this.searchSorts = CollectionUtil.copyAsImmutableList(Assertions.containsNoNulls("searchSorts", searchSorts));
    }

    @Override
    public List<SearchSort> getSearchSorts() {
        return this.searchSorts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.searchSorts.isEmpty()) {
            sb.append("order by ");
        }
        Iterator<SearchSort> searchSortIterator = this.searchSorts.iterator();
        while (searchSortIterator.hasNext()) {
            SearchSort searchSort = searchSortIterator.next();
            sb.append(searchSort.getField());
            if (searchSort.getOrder() != null) {
                sb.append(' ').append(searchSort.getOrder());
            }
            if (!searchSortIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByImpl orderBy = (OrderByImpl)o;
        return ((Object)this.searchSorts).equals(orderBy.searchSorts);
    }

    public int hashCode() {
        return ((Object)this.searchSorts).hashCode();
    }
}

