/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.JiraApplicationContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;

public class Email
extends com.atlassian.mail.Email {
    public static final String HEADER_JIRA_FINGER_PRINT = "X-JIRA-FingerPrint";
    private ConfigurationDependencies configurationDependencies;
    private static final ConfigurationDependencies PRODUCTION_DEPENDENCIES = new ConfigurationDependencies(){

        @Override
        public ApplicationProperties getApplicationProperties() {
            return ComponentAccessor.getApplicationProperties();
        }

        @Override
        public JiraApplicationContext getJiraApplicationContext() {
            return ComponentAccessor.getComponentOfType(JiraApplicationContext.class);
        }
    };

    public Email(String to) {
        this(to, PRODUCTION_DEPENDENCIES);
    }

    public Email(String to, String cc, String bcc) {
        this(to, cc, bcc, PRODUCTION_DEPENDENCIES);
    }

    Email(String to, ConfigurationDependencies configurationDependencies) {
        super(to);
        this.configurationDependencies = configurationDependencies;
        this.removePrecedenceHeaderIfNeeded();
        this.addFingerPrintHeader();
        this.setEncoding(this.getMailEncoding());
    }

    Email(String to, String cc, String bcc, ConfigurationDependencies configurationDependencies) {
        super(to, cc, bcc);
        this.configurationDependencies = configurationDependencies;
        this.removePrecedenceHeaderIfNeeded();
        this.addFingerPrintHeader();
        this.setEncoding(this.getMailEncoding());
    }

    private void removePrecedenceHeaderIfNeeded() {
        if (this.isExcludePrecedenceHeader()) {
            this.removeHeader("Precedence");
            this.removeHeader("Auto-Submitted");
        }
    }

    private String getMailEncoding() {
        return this.configurationDependencies.getApplicationProperties().getMailEncoding();
    }

    private boolean isExcludePrecedenceHeader() {
        ApplicationProperties properties = this.configurationDependencies.getApplicationProperties();
        return properties.getOption("jira.option.precedence.header.exclude");
    }

    private void addFingerPrintHeader() {
        this.addHeader(HEADER_JIRA_FINGER_PRINT, this.configurationDependencies.getJiraApplicationContext().getFingerPrint());
    }

    static interface ConfigurationDependencies {
        public ApplicationProperties getApplicationProperties();

        public JiraApplicationContext getJiraApplicationContext();
    }
}

