/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import org.apache.commons.lang.StringUtils;

public final class PortUtil {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;

    private PortUtil() {
    }

    public static int parsePort(String port) {
        if (StringUtils.isBlank((String)port)) {
            return -1;
        }
        try {
            int portInt = Integer.parseInt(port.trim());
            if (PortUtil.isValidPort(portInt)) {
                return portInt;
            }
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean isValidPort(String port) {
        return PortUtil.parsePort(port) >= 0;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

