/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.configurable.ObjectConfigurable;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.util.handler.MessageErrorHandler;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PortUtil;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.sun.mail.pop3.POP3Message;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public abstract class MailFetcherService
extends AbstractMessageHandlingService
implements ObjectConfigurable {
    private static final Logger log = Logger.getLogger(MailFetcherService.class);
    private static final String OLD_MAIL_DISABLED_KEY = "atlassian.mail.popdisabled";
    private static final String MAIL_DISABLED_KEY = "atlassian.mail.fetchdisabled";
    private static final String KEY_PORT = "port";
    private static final String KEY_MAIL_SERVER = "popserver";
    protected Long mailserverId = null;
    public static final String USE_SSL = "usessl";
    public static final String FORWARD_EMAIL = "forwardEmail";
    protected static final String DEFAULT_FOLDER = "INBOX";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private final ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
    private final String baseUrl = this.applicationProperties.getString("jira.baseurl");
    private static final String ERROR_TEMPLATE = "errorinhandler.vm";
    private int port = -1;

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(KEY_MAIL_SERVER)) {
            try {
                this.mailserverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            }
            catch (Exception e) {
                log.error((Object)("Invalid mail server id: " + e), (Throwable)e);
            }
        }
        if (this.hasProperty(KEY_PORT)) {
            int parsedPort = PortUtil.parsePort(this.getProperty(KEY_PORT));
            if (parsedPort >= 0) {
                this.port = parsedPort;
            } else {
                this.port = -1;
                log.error((Object)("Invalid port number: " + this.getProperty(KEY_PORT) + " for mail service: " + this.getName() + ". Using the default port for this service type."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Store store;
        if (this.isMailDisabled()) {
            return;
        }
        MailServer mailserver = this.getMailServer();
        if (mailserver == null) {
            return;
        }
        String hostname = mailserver.getHostname();
        String username = mailserver.getUsername();
        String password = mailserver.getPassword();
        if (hostname == null || username == null || password == null) {
            log.warn((Object)this.addHandlerInfo("Cannot retrieve mail due to a missing parameter in Mail Server '" + mailserver.getName() + "': [host," + hostname + "],[username," + username + "],[password," + password + "]"));
            return;
        }
        Folder folder = null;
        Properties props = mailserver.getProperties();
        Session session = Session.getInstance((Properties)props, null);
        String protocol = null;
        try {
            protocol = this.getProtocol(this.useSSL());
            store = session.getStore(protocol);
        }
        catch (NoSuchProviderException e) {
            log.error((Object)this.addHandlerInfo("Error getting provider for protocol " + protocol + ": " + (Object)((Object)e)), (Throwable)e);
            return;
        }
        try {
            store.connect(hostname, this.port, username, password);
        }
        catch (MessagingException e) {
            log.error((Object)this.addHandlerInfo("Error connecting to host '" + hostname + "' as user '" + username + "' via protocol '" + protocol + "': " + (Object)((Object)e)), (Throwable)e);
            return;
        }
        try {
            folder = store.getFolder(this.getFolderName());
            folder.open(2);
            Message[] messages = folder.getMessages();
            log.debug((Object)this.addHandlerInfo("There are " + messages.length + " messages in the " + protocol + " folder"));
            for (Message message : messages) {
                MessageErrorHandler errorHandler = new MessageErrorHandler();
                this.getHandler().setErrorHandler(errorHandler);
                boolean deleteThisMessage = false;
                String msgId = null;
                try {
                    String string = msgId = message.getHeader("Message-ID") != null ? message.getHeader("Message-ID")[0] : "null";
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("Message Subject: " + message.getSubject()));
                            log.debug((Object)("Message-ID: " + msgId));
                        }
                        catch (MessagingException e) {
                            log.warn((Object)"Messaging exception thrown on getting message subject. Message may have corrupt headers.", (Throwable)e);
                        }
                    }
                    deleteThisMessage = this.getHandler().handleMessage(message);
                    if (errorHandler.getError() == null || this.forwardEmailParam() == null || deleteThisMessage) continue;
                    log.debug((Object)("Forwarding Message: " + msgId));
                    deleteThisMessage = this.forwardEmail(message, errorHandler);
                }
                catch (Exception e) {
                    log.error((Object)this.addHandlerInfo("Exception: " + e.getLocalizedMessage()), (Throwable)e);
                }
                finally {
                    if (message != null) {
                        if (message instanceof POP3Message) {
                            ((POP3Message)message).invalidate(true);
                        }
                        if (deleteThisMessage) {
                            log.debug((Object)("Deleting Message: " + msgId));
                            message.setFlag(Flags.Flag.DELETED, true);
                        }
                    }
                }
            }
        }
        catch (MessagingException e) {
            log.error((Object)this.addHandlerInfo("Messaging Exception in service '" + this.getClass().getName() + "' when getting mail: " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(true);
                }
                store.close();
            }
            catch (Exception e) {
                log.debug((Object)this.addHandlerInfo("Error whilst closing folder and store: " + e.getMessage()));
            }
        }
    }

    MailServer getMailServer() {
        MailServer mailserver = null;
        if (this.mailserverId != null) {
            try {
                mailserver = MailFactory.getServerManager().getMailServer(new Long(this.getProperty(KEY_MAIL_SERVER)));
            }
            catch (Exception e) {
                log.error((Object)this.addHandlerInfo("Could not retrieve mail server: " + e), (Throwable)e);
            }
        } else {
            log.error((Object)(this.getClass().getName() + " cannot run without a configured Mail Server"));
        }
        return mailserver;
    }

    boolean isMailDisabled() {
        if (Boolean.getBoolean(OLD_MAIL_DISABLED_KEY)) {
            log.info((Object)"Service disabled by 'atlassian.mail.popdisabled' property.");
            return true;
        }
        if (Boolean.getBoolean(MAIL_DISABLED_KEY)) {
            log.info((Object)"Service disabled by 'atlassian.mail.fetchdisabled' property.");
            return true;
        }
        return false;
    }

    protected abstract String getProtocol(boolean var1);

    protected abstract String getFolderName();

    private boolean useSSL() {
        try {
            return "true".equals(this.getProperty(USE_SSL));
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving SSL flag."), (Throwable)((Object)e));
        }
    }

    private String forwardEmailParam() {
        try {
            return this.getProperty(FORWARD_EMAIL);
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving Forward Email flag."), (Throwable)((Object)e));
        }
    }

    private com.atlassian.jira.mail.Email createErrorForwardEmail(Message message, MessageErrorHandler errorHandler) throws VelocityException, MessagingException {
        com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(this.forwardEmailParam());
        String error = errorHandler.getError();
        String exceptionString = errorHandler.getException();
        email.setSubject(MailFetcherService.getI18nHelper().getText("template.errorinhandler.subject", message.getSubject()));
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.putAll(this.getVelocityParams(error));
        String body = ComponentAccessor.getVelocityManager().getEncodedBody(EMAIL_TEMPLATES, "text/errorinhandler.vm", this.baseUrl, this.applicationProperties.getString("webwork.i18n.encoding"), contextParams);
        email.setBody(body);
        MimeMultipart mp = new MimeMultipart();
        if (exceptionString != null) {
            MimeBodyPart exception = new MimeBodyPart();
            exception.setContent((Object)exceptionString, "text/plain");
            exception.setFileName("ErrorStackTrace.txt");
            mp.addBodyPart((BodyPart)exception);
        }
        MimeBodyPart messageAttachment = new MimeBodyPart();
        messageAttachment.setContent((Object)message, "message/rfc822");
        String subject = message.getSubject();
        if (StringUtils.isBlank((String)subject)) {
            subject = "NoSubject";
        }
        messageAttachment.setFileName(subject + ".eml");
        mp.addBodyPart((BodyPart)messageAttachment);
        email.setMultipart((Multipart)mp);
        return email;
    }

    private boolean forwardEmail(Message message, MessageErrorHandler errorHandler) throws MailException {
        if (TextUtils.verifyEmail((String)this.forwardEmailParam())) {
            try {
                com.atlassian.jira.mail.Email email = this.createErrorForwardEmail(message, errorHandler);
                this.sendMail(email);
                return true;
            }
            catch (VelocityException e) {
                log.error((Object)this.addHandlerInfo("Could not create email template for."), (Throwable)e);
            }
            catch (MessagingException e) {
                log.error((Object)this.addHandlerInfo("Could not retrieve information from message."), (Throwable)e);
            }
        } else {
            log.warn((Object)this.addHandlerInfo("Forward Email is invalid."));
        }
        return false;
    }

    private void sendMail(com.atlassian.jira.mail.Email email) throws MailException {
        SMTPMailServer mailserver = MailFactory.getServerManager().getDefaultSMTPMailServer();
        if (mailserver == null) {
            log.warn((Object)"You do not currently have a smtp mail server set up yet.");
        } else if (MailFactory.isSendingDisabled()) {
            log.warn((Object)"Sending mail is currently disabled in Jira.");
        } else {
            email.setFrom(mailserver.getDefaultFrom());
            mailserver.send((Email)email);
        }
    }

    private Map<String, Object> getVelocityParams(String error) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String handlerName = this.getHandler().getClass().toString();
        try {
            params.put("i18n", MailFetcherService.getI18nHelper());
            params.put("handlerName", handlerName);
            Long serverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            params.put("serverName", MailFactory.getServerManager().getMailServer(serverId).getName());
            params.put("error", error);
            params.put("baseurl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
        }
        catch (ObjectConfigurationException e) {
            log.error((Object)"Could not retrieve mail server", (Throwable)((Object)e));
        }
        catch (MailException e) {
            log.error((Object)"Could not retrieve mail server", (Throwable)e);
        }
        return params;
    }

    private String addHandlerInfo(String msg) {
        return this.getName() + "[" + this.mailserverId + "]: " + msg;
    }

    private static I18nHelper getI18nHelper() {
        return ComponentAccessor.getI18nHelperFactory().getInstance((User)null);
    }
}

