/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.PathUtils;

public interface AttachmentPathManager {
    public static final String ATTACHMENTS_DIR = PathUtils.joinPaths("data", "attachments");

    public String getDefaultAttachmentPath();

    public String getAttachmentPath();

    public void setCustomAttachmentPath(String var1);

    public void setUseDefaultDirectory();

    public boolean getUseDefaultDirectory();

    public void disableAttachments();

    public Mode getMode();

    public static class PropertiesAdaptor
    implements AttachmentPathManager {
        private final ApplicationProperties applicationProperties;
        private final JiraHome jiraHome;

        public PropertiesAdaptor(ApplicationProperties applicationProperties, JiraHome jiraHome) {
            this.applicationProperties = applicationProperties;
            this.jiraHome = jiraHome;
        }

        @Override
        public String getDefaultAttachmentPath() {
            return PathUtils.appendFileSeparator(this.jiraHome.getHomePath()) + ATTACHMENTS_DIR;
        }

        @Override
        public String getAttachmentPath() {
            switch (this.getMode()) {
                case DISABLED: {
                    return this.applicationProperties.getString("jira.path.attachments");
                }
                case DEFAULT: {
                    return this.getDefaultAttachmentPath();
                }
                case CUSTOM: {
                    return this.applicationProperties.getString("jira.path.attachments");
                }
            }
            throw new IllegalArgumentException("Unknown attachment mode " + this.getMode().name());
        }

        @Override
        public void setCustomAttachmentPath(String path) {
            this.applicationProperties.setString("jira.path.attachments", path);
            this.applicationProperties.setOption("jira.path.attachments.use.default.directory", Boolean.FALSE);
            this.applicationProperties.setOption("jira.option.allowattachments", true);
        }

        @Override
        public void setUseDefaultDirectory() {
            this.applicationProperties.setString("jira.path.attachments", this.getDefaultAttachmentPath());
            this.applicationProperties.setOption("jira.path.attachments.use.default.directory", Boolean.TRUE);
            this.applicationProperties.setOption("jira.option.allowattachments", true);
        }

        @Override
        public boolean getUseDefaultDirectory() {
            return this.getMode() == Mode.DEFAULT;
        }

        @Override
        public void disableAttachments() {
            this.applicationProperties.setOption("jira.option.allowattachments", false);
        }

        @Override
        public Mode getMode() {
            if (!this.applicationProperties.getOption("jira.option.allowattachments")) {
                return Mode.DISABLED;
            }
            if (this.applicationProperties.getOption("jira.path.attachments.use.default.directory")) {
                return Mode.DEFAULT;
            }
            return Mode.CUSTOM;
        }
    }

    public static enum Mode {
        DEFAULT,
        CUSTOM,
        DISABLED;

    }
}

